<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Receivable;
use App\Models\Sale;
use App\Models\ProductInquiry;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;

class PrintController extends Controller
{
    /**
     * Generate PDF untuk Nota Pemesanan
     */
    public function orderInvoice(Order $order)
    {
        $order->load(['product', 'user']);
        
        $pdf = Pdf::loadView('admin.print.order-invoice', compact('order'))
            ->setPaper('A4', 'portrait')
            ->setOptions([
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled' => true,
                'defaultFont' => 'Arial'
            ]);
        
        $filename = 'Nota_Pemesanan_' . $order->id . '_' . now()->format('Y-m-d') . '.pdf';
        
        return $pdf->download($filename);
    }
    
    /**
     * Generate PDF untuk Kwitansi DP
     */
    public function receivableReceipt(Receivable $receivable)
    {
        $receivable->load(['order.product', 'user']);
        
        $pdf = Pdf::loadView('admin.print.receivable-receipt', compact('receivable'))
            ->setPaper('A4', 'portrait')
            ->setOptions([
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled' => true,
                'defaultFont' => 'Arial'
            ]);
        
        $filename = 'Kwitansi_DP_' . $receivable->receivable_number . '_' . now()->format('Y-m-d') . '.pdf';
        
        return $pdf->download($filename);
    }
    
    /**
     * Generate PDF untuk Invoice Penjualan
     */
    public function salesInvoice(Sale $sale)
    {
        $sale->load(['product', 'order', 'user']);
        
        $pdf = Pdf::loadView('admin.print.sales-invoice', compact('sale'))
            ->setPaper('A4', 'portrait')
            ->setOptions([
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled' => true,
                'defaultFont' => 'Arial'
            ]);
        
        $filename = 'Invoice_Penjualan_' . $sale->id . '_' . now()->format('Y-m-d') . '.pdf';
        
        return $pdf->download($filename);
    }
    
    /**
     * Preview Nota Pemesanan (untuk lihat dulu sebelum download)
     */
    public function orderInvoicePreview(Order $order)
    {
        $order->load(['product', 'user']);
        return view('admin.print.order-invoice', compact('order'));
    }
    
    /**
     * Preview Kwitansi DP (untuk lihat dulu sebelum download)
     */
    public function receivableReceiptPreview(Receivable $receivable)
    {
        $receivable->load(['order.product', 'user']);
        return view('admin.print.receivable-receipt', compact('receivable'));
    }
    
    /**
     * Preview Invoice Penjualan (untuk lihat dulu sebelum download)
     */
    public function salesInvoicePreview(Sale $sale)
    {
        $sale->load(['product', 'order', 'user']);
        return view('admin.print.sales-invoice', compact('sale'));
    }

    /**
     * Quotation Offer PDF (Customer copy)
     */
    public function quotationOffer(ProductInquiry $inquiry)
    {
        $inquiry->load(['product']);

        $pdf = Pdf::loadView('admin.print.quotation-offer', compact('inquiry'))
            ->setPaper('A4', 'portrait')
            ->setOptions([
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled' => true,
                'defaultFont' => 'Arial'
            ]);

        $filename = 'Quotation_' . ($inquiry->tracking_code ?? $inquiry->id) . '_' . now()->format('Y-m-d') . '.pdf';
        return $pdf->download($filename);
    }

    /**
     * Quotation Offer Preview (for admin)
     */
    public function quotationOfferPreview(ProductInquiry $inquiry)
    {
        $inquiry->load(['product']);
        return view('admin.print.quotation-offer', compact('inquiry'));
    }
}
