<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ServicePackage;
use Illuminate\Http\Request;

class ServicePackageController extends Controller
{
    public function index()
    {
        $servicePackages = ServicePackage::withCount('productions')->latest()->paginate(10);
        return view('admin.service-packages.index', compact('servicePackages'));
    }

    public function create()
    {
        return view('admin.service-packages.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'  => 'required|string|max:255',
            'price' => 'required|numeric|min:0',
        ]);

        ServicePackage::create([
            'name'        => $request->name,
            'price'       => $request->price,
            'description' => $request->description,
            'is_active'   => $request->is_active ?? 1,
        ]);

        return redirect()->route('admin.service-packages.index')
            ->with('success', 'Service Package berhasil ditambahkan');
    }

    public function edit($id)
    {
        $servicePackage = ServicePackage::findOrFail($id);
        return view('admin.service-packages.edit', compact('servicePackage'));
    }

    public function update(Request $request, $id)
    {
        $servicePackage = ServicePackage::findOrFail($id);

        $request->validate([
            'name'  => 'required|string|max:255',
            'price' => 'required|numeric|min:0',
        ]);

        $servicePackage->update($request->all());

        return redirect()->route('admin.service-packages.index')
            ->with('success', 'Service Package berhasil diperbarui');
    }

    public function show($id)
    {
        $servicePackage = ServicePackage::findOrFail($id);
        return view('admin.service-packages.show', compact('servicePackage'));
    }

    public function destroy($id)
    {
        ServicePackage::findOrFail($id)->delete();

        return back()->with('success', 'Service Package berhasil dihapus');
    }

    public function bulkDestroy(Request $request)
    {
        ServicePackage::whereIn('id', $request->ids)->delete();

        return back()->with('success', 'Service Package berhasil dihapus massal');
    }
}
