<?php

namespace App\Http\Controllers\Teknisi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sparepart;

class SparepartController extends Controller
{
    public function index(Request $request)
    {
        $query = Sparepart::where('is_active', true);

        // Search filter
        if ($request->filled('search') && trim($request->search) !== '') {
            $search = trim($request->search);
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%')
                    ->orWhere('description', 'like', '%' . $search . '%')
                    ->orWhere('brand', 'like', '%' . $search . '%')
                    ->orWhere('supplier', 'like', '%' . $search . '%')
                    ->orWhere('part_code', 'like', '%' . $search . '%')
                    ->orWhere('part_number', 'like', '%' . $search . '%');
            });
        }

        // Filter by stock status
        if ($request->filled('stock_status')) {
            if ($request->stock_status === 'low') {
                $query->where('stock', '<=', 5);
            } elseif ($request->stock_status === 'medium') {
                $query->where('stock', '>', 5)->where('stock', '<=', 20);
            } elseif ($request->stock_status === 'safe') {
                $query->where('stock', '>', 20);
            }
        }

        // Filter by brand
        if ($request->filled('brand')) {
            $query->where('brand', $request->brand);
        }

        $spareparts = $query->latest()->paginate(15);
        $spareparts->appends($request->only(['search', 'stock_status', 'brand']));

        // Get unique brands for filter dropdown
        $brands = Sparepart::where('is_active', true)
            ->whereNotNull('brand')
            ->distinct()
            ->pluck('brand')
            ->sort()
            ->values();

        return view('teknisi.spareparts.index', compact('spareparts', 'brands'));
    }
}
























