<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'image',
        'parent_id',
    ];

    // Relasi ke produk (product)
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    // Relasi ke parent category (kategori besar)
    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    // Relasi ke sub categories (sub kategori)
    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    // Scope untuk mendapatkan hanya kategori besar (parent)
    public function scopeParents($query)
    {
        return $query->whereNull('parent_id');
    }

    // Scope untuk mendapatkan hanya sub kategori
    public function scopeChildren($query)
    {
        return $query->whereNotNull('parent_id');
    }

    // Cek apakah kategori ini adalah parent
    public function isParent()
    {
        return is_null($this->parent_id);
    }

    // Cek apakah kategori ini adalah sub kategori
    public function isChild()
    {
        return !is_null($this->parent_id);
    }
}
