<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChartOfAccount extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'kode_akun',
        'nama_akun',
        'tabel_bantuan',
        'pos_saldo',
        'pos_laporan',
        'saldo_awal_debet',
        'saldo_awal_kredit',
        'is_active',
        'sort_order',
        'keterangan',
    ];

    protected $casts = [
        'saldo_awal_debet' => 'decimal:2',
        'saldo_awal_kredit' => 'decimal:2',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    /**
     * Relationship with JournalEntry
     */
    public function journalEntries(): HasMany
    {
        return $this->hasMany(JournalEntry::class, 'kd_perk', 'kode_akun');
    }

    /**
     * Scope untuk akun aktif
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope untuk filter berdasarkan pos laporan
     */
    public function scopeByReportPosition($query, $position)
    {
        return $query->where('pos_laporan', $position);
    }

    /**
     * Scope untuk filter berdasarkan pos saldo
     */
    public function scopeByBalancePosition($query, $position)
    {
        return $query->where('pos_saldo', $position);
    }

    /**
     * Get saldo awal (net)
     */
    public function getSaldoAwalNetAttribute()
    {
        if ($this->pos_saldo === 'DEBET') {
            return ($this->saldo_awal_debet ?? 0) - ($this->saldo_awal_kredit ?? 0);
        } else {
            return ($this->saldo_awal_kredit ?? 0) - ($this->saldo_awal_debet ?? 0);
        }
    }
}
