<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductSparepart extends Model
{
    use HasFactory;

    protected $table = 'product_sparepart';

    protected $fillable = [
        'product_id',
        'name',
        'type',
        'quantity',
        'unit',
        'usage_cost',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'usage_cost' => 'decimal:2',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}

