<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServicePackage extends Model
{
    protected $table = 'service_packages';

    protected $fillable = [
        'name',
        'price',
        'description',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */
    public function productions()
    {
        return $this->hasMany(Production::class);
    }

    /**
     * Get jumlah produksi yang menggunakan paket ini
     */
    public function getProductionsCountAttribute()
    {
        return $this->productions()->count();
    }
}
