<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Guard: jika tabel belum ada (karena urutan timestamp), jangan error
        if (!Schema::hasTable('product_inquiries')) {
            return; // akan ditangani oleh migration perbaikan yang bertimestamp lebih baru
        }

        // Tambahkan kolom hanya jika belum ada
        if (!Schema::hasColumn('product_inquiries', 'order_id')) {
            Schema::table('product_inquiries', function (Blueprint $table) {
                // Relasi ke Order setelah convert
                $table->foreignId('order_id')->nullable()->after('product_id')->constrained('orders')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('product_inquiries') && Schema::hasColumn('product_inquiries', 'order_id')) {
            Schema::table('product_inquiries', function (Blueprint $table) {
                $table->dropForeign(['order_id']);
                $table->dropColumn('order_id');
            });
        }
    }
};

