<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();

            // Data pembeli
            $table->string('customer_name');        // Nama pembeli 
            $table->string('customer_email');       // Email pembeli
            $table->string('phone_number');         // Nomor telepon
            $table->string('address');              // Alamat pengiriman / penagihan

            // Relasi
            $table->unsignedBigInteger('user_id')->nullable();      // ID user (harus login)    
            $table->unsignedBigInteger('product_id')->nullable();   // Produk yang dibeli

            // Data pembelian
            $table->integer('quantity')->default(1);    // Jumlah produk
            $table->decimal('price', 15, 2);            // Harga satuan produk saat dibeli
            $table->decimal('total_price', 15, 2);      // Total harga = price * quantity

            // Status & pembayaran
            $table->string('payment_method')->nullable();   // Transfer, COD, e-wallet, dll
            $table->string('status')->default('menunggu');  // menunggu, diproses, selesai

            // Midtrans
            $table->string('midtrans_transaction_id')->nullable();
            $table->string('midtrans_payment_type')->nullable();
            $table->string('midtrans_va_number')->nullable();
            $table->string('midtrans_status')->nullable();

            // Relasi opsional (gunakan jika kamu ingin jaga integritas data)
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null')->onUpdate('cascade');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('set null')->onUpdate('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
