<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('materials', function (Blueprint $table) {
            $table->id();
            $table->string('material_code')->unique()->nullable(); // kode unik bahan
            $table->string('name');
            $table->integer('stock')->default(0);
            $table->string('unit')->nullable(); // e.g., kg, liter, meter
            $table->decimal('price', 15, 2)->nullable(); // per unit
            $table->string('category')->nullable(); // kategori bahan (logam, kayu, kimia, dll)
            $table->string('supplier')->nullable(); // nama supplier bahan
            $table->string('image')->nullable(); // gambar bahan
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true); // status aktif/tidak
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('materials');
    }
};
