<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productions', function (Blueprint $table) {
            $table->id();

            // Relasi ke order & produk
            $table->foreignId('order_id')->constrained('orders')->onDelete('cascade'); // pesanan terkait
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade'); // produk yang diproduksi

            // Informasi umum produksi
            $table->date('start_date')->nullable();  // tanggal mulai produksi
            $table->date('end_date')->nullable();    // tanggal selesai produksi (estimasi / realisasi)
            $table->string('status')->default('menunggu'); // menunggu, dalam_proses, selesai, dibatalkan

            // Biaya & hasil produksi
            $table->decimal('total_material_cost', 15, 2)->default(0);  // total biaya bahan terpakai
            $table->decimal('total_sparepart_cost', 15, 2)->default(0); // total biaya sparepart terpakai
            $table->decimal('total_production_cost', 15, 2)->default(0); // total keseluruhan biaya produksi

            // Catatan tambahan
            $table->text('notes')->nullable(); // catatan teknisi atau admin produksi

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productions');
    }
};
