<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('production_spareparts', function (Blueprint $table) {
            $table->id();

            // Relasi ke produksi dan sparepart
            $table->foreignId('production_id')->constrained('productions')->onDelete('cascade');
            $table->foreignId('sparepart_id')->constrained('spareparts')->onDelete('cascade');

            // Detail penggunaan sparepart
            $table->integer('quantity')->default(1);       // jumlah sparepart yang digunakan
            $table->string('unit')->nullable();            // satuan (pcs, set, dll)
            $table->decimal('unit_cost', 15, 2)->nullable(); // harga satuan sparepart saat produksi
            $table->decimal('total_cost', 15, 2)->nullable(); // total = quantity * unit_cost

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('production_spareparts');
    }
};
