<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('back_office_transactions', function (Blueprint $table) {
            $table->id();

            // Type: income atau expense
            $table->enum('type', ['income', 'expense'])->comment('Tipe transaksi: pemasukan atau pengeluaran');

            // Category
            $table->string('category', 50)->comment('Kategori transaksi');

            // Description & Details
            $table->string('description')->comment('Deskripsi detail transaksi');
            $table->decimal('amount', 15, 2)->comment('Nominal dalam Rupiah');

            // Transaction Info
            $table->date('transaction_date')->comment('Tanggal transaksi');
            $table->string('reference_number', 100)->nullable()->comment('Nomor referensi/invoice');

            // Notes & Attachment
            $table->text('notes')->nullable()->comment('Catatan tambahan');
            $table->string('attachment')->nullable()->comment('Path file bukti (foto/pdf)');

            // User tracking
            $table->foreignId('created_by')->constrained('users')->comment('User yang membuat');

            // Timestamps
            $table->timestamps();
            $table->softDeletes(); // Untuk audit trail

            // Indexes untuk performa
            $table->index('type');
            $table->index('category');
            $table->index('transaction_date');
            $table->index(['type', 'transaction_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('back_office_transactions');
    }
};
