<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->foreignId('teknisi_id')->nullable()->constrained('users')->onDelete('set null')->after('product_id');
            $table->timestamp('assigned_at')->nullable()->after('teknisi_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->dropForeign(['teknisi_id']);
            $table->dropColumn(['teknisi_id', 'assigned_at']);
        });
    }
};
