<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumn('product_inquiries', 'status')) {
            // Pakai raw SQL agar tidak perlu doctrine/dbal
            DB::statement("ALTER TABLE `product_inquiries` MODIFY `status` VARCHAR(50) NOT NULL");
        }
    }

    public function down(): void
    {
        // Tidak tahu ukuran semula; fallback ke VARCHAR(20)
        if (Schema::hasColumn('product_inquiries', 'status')) {
            DB::statement("ALTER TABLE `product_inquiries` MODIFY `status` VARCHAR(20) NOT NULL");
        }
    }
};


