<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bukti Serah Terima - Order #{{ $order->id }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }
        
        .content-container {
            max-width: 180mm;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #1a1a1a;
            padding-bottom: 20px;
            margin-bottom: 25px;
        }
        
        .company-name {
            font-size: 26px;
            font-weight: bold;
            margin-bottom: 8px;
            letter-spacing: 1.5px;
            color: #1a1a1a;
        }
        
        .company-address {
            font-size: 11px;
            color: #555;
            margin-bottom: 4px;
            line-height: 1.6;
        }
        
        .document-title {
            font-size: 22px;
            font-weight: bold;
            margin: 20px 0 15px 0;
            color: #27ae60;
            text-transform: uppercase;
            letter-spacing: 1px;
            text-align: center;
            padding: 10px 0;
            border-top: 2px solid #27ae60;
            border-bottom: 2px solid #27ae60;
        }
        
        .document-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 25px;
            padding: 18px;
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
        }
        
        .info-left, .info-right {
            width: 48%;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 8px;
        }
        
        .info-label {
            font-weight: bold;
            width: 130px;
            color: #333;
        }
        
        .info-value {
            flex: 1;
            color: #000;
        }
        
        .section {
            margin: 20px 0;
        }
        
        .section-title {
            font-size: 15px;
            font-weight: bold;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 3px solid #27ae60;
            color: #1e8449;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .product-table th,
        .product-table td {
            border: 1px solid #dee2e6;
            padding: 12px 10px;
            text-align: left;
        }
        
        .product-table th {
            background: linear-gradient(to bottom, #27ae60 0%, #229954 100%);
            color: #ffffff;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 11px;
            letter-spacing: 0.5px;
            border: 1px solid #1e8449;
        }
        
        .product-table td {
            background-color: #ffffff;
            color: #333;
        }
        
        .product-table tbody tr:hover {
            background-color: #f8f9fa;
        }
        
        .product-table .text-right {
            text-align: right;
        }
        
        .handover-details {
            margin: 25px 0;
            padding: 20px;
            background-color: #e8f5e9;
            border: 2px solid #27ae60;
            border-radius: 8px;
        }
        
        .handover-title {
            font-size: 17px;
            font-weight: bold;
            color: #1e8449;
            margin-bottom: 18px;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding-bottom: 10px;
            border-bottom: 2px solid #27ae60;
        }
        
        .handover-grid {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        
        .handover-left, .handover-right {
            width: 48%;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .detail-label {
            font-weight: bold;
            color: #333;
        }
        
        .detail-value {
            text-align: right;
            font-weight: bold;
            color: #000;
        }
        
        .status-confirmed {
            background-color: #d4edda;
            border: 2px solid #27ae60;
            padding: 15px;
            margin-top: 18px;
            border-radius: 8px;
            text-align: center;
            color: #155724;
            font-weight: bold;
            font-size: 15px;
            letter-spacing: 0.5px;
        }
        
        .photos-section {
            margin: 25px 0;
            page-break-inside: avoid;
        }
        
        .photo-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-top: 15px;
        }
        
        .photo-item {
            border: 2px solid #dee2e6;
            padding: 12px;
            text-align: center;
            background-color: #f8f9fa;
            border-radius: 8px;
            min-height: 200px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .photo-item img {
            max-width: 100%;
            max-height: 180px;
            width: auto;
            height: auto;
            object-fit: contain;
            border: 1px solid #ccc;
            border-radius: 4px;
            background-color: #ffffff;
        }
        
        .photo-label {
            font-size: 9px;
            color: #666;
            margin-top: 3px;
        }
        
        .notes-section {
            margin: 20px 0;
            padding: 18px;
            background-color: #f8f9fa;
            border-left: 5px solid #3b82f6;
            border-radius: 6px;
        }
        
        .notes-title {
            font-weight: bold;
            margin-bottom: 8px;
            color: #333;
        }
        
        .notes-content {
            font-size: 11px;
            color: #555;
            line-height: 1.6;
        }
        
        .signature-section {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
            padding-top: 20px;
            border-top: 2px solid #dee2e6;
        }
        
        .signature-box {
            text-align: center;
            width: 45%;
        }
        
        .signature-label {
            font-weight: bold;
            margin-bottom: 8px;
            font-size: 13px;
            color: #333;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .signature-line {
            border-bottom: 2px solid #1a1a1a;
            height: 60px;
            margin-bottom: 12px;
            margin-top: 5px;
        }
        
        .signature-name {
            font-size: 11px;
            color: #333;
        }
        
        .signature-date {
            font-size: 10px;
            color: #666;
            margin-top: 5px;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
        
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            padding: 5px 0;
        }
        
        .total-label {
            font-weight: bold;
            width: 150px;
        }
        
        .total-value {
            width: 120px;
            text-align: right;
            font-weight: bold;
        }
        
        .grand-total {
            border-top: 2px solid #000;
            padding-top: 10px;
            font-size: 14px;
            font-weight: bold;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10mm;
                font-size: 11px;
                background: #fff;
            }
            
            .content-container {
                max-width: 100%;
                margin: 0 auto;
                background: #fff;
                padding: 0;
                position: static;
                left: auto;
                transform: none;
            }
            
            .header {
                margin-bottom: 15px;
                padding-bottom: 10px;
            }
            
            .company-name {
                font-size: 20px;
            }
            
            .company-address {
                font-size: 10px;
            }
            
            .document-title {
                font-size: 18px;
                margin: 10px 0 8px 0;
            }
            
            .document-info {
                margin-bottom: 15px;
                padding: 10px;
            }
            
            .info-row {
                margin-bottom: 5px;
            }
            
            .product-table {
                font-size: 10px;
            }
            
            .product-table th,
            .product-table td {
                padding: 6px;
            }
            
            .handover-details {
                margin: 15px 0;
                padding: 10px;
            }
            
            .handover-title {
                font-size: 14px;
            }
            
            .signature-section {
                margin-top: 30px;
            }
            
            .footer {
                margin-top: 20px;
                font-size: 9px;
            }
        }
    </style>
</head>
<body>
    <div class="content-container">
        <!-- Header Perusahaan -->
        <div class="header">
            <div class="company-name">POLJAM TECHNO WORKSHOP</div>
            <div class="company-address">Jl. Workshop No. 123, Jakarta</div>
            <div class="company-address">Telp: (021) 123-4567 | Email: info@poljamtechno.com</div>
        </div>
        
        <!-- Judul Dokumen -->
        <div class="document-title">BUKTI SERAH TERIMA PRODUK</div>
        
        <!-- Informasi Dokumen -->
        <div class="document-info">
            <div class="info-left">
                <div class="info-row">
                    <div class="info-label">No. Dokumen:</div>
                    <div class="info-value">#HT-{{ $order->id }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Tanggal Serah Terima:</div>
                    <div class="info-value">{{ $order->handover_at ? $order->handover_at->format('d M Y H:i') : now()->format('d M Y H:i') }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Order ID:</div>
                    <div class="info-value">#{{ $order->id }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Customer:</div>
                    <div class="info-value">{{ $order->customer_name }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Email:</div>
                    <div class="info-value">{{ $order->customer_email }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Telepon:</div>
                    <div class="info-value">{{ $order->phone_number ?? '-' }}</div>
                </div>
            </div>
            <div class="info-right">
                <div class="info-row">
                    <div class="info-label">Status:</div>
                    <div class="info-value">{{ $order->handover_status_label ?? 'N/A' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Diserahkan Oleh:</div>
                    <div class="info-value">{{ $order->handoverBy->name ?? 'Admin' }}</div>
                </div>
                @if($order->production && $order->production->teknisi)
                <div class="info-row">
                    <div class="info-label">Teknisi:</div>
                    <div class="info-value">{{ $order->production->teknisi->name }}</div>
                </div>
                @endif
                @if($order->production && $order->production->supervisor)
                <div class="info-row">
                    <div class="info-label">Supervisor:</div>
                    <div class="info-value">{{ $order->production->supervisor->name }}</div>
                </div>
                @endif
                <div class="info-row">
                    <div class="info-label">Alamat Pengiriman:</div>
                    <div class="info-value">{{ $order->address ?? '-' }}</div>
                </div>
            </div>
        </div>
        
        <!-- Detail Produk -->
        <div class="section">
            <div class="section-title">DETAIL PRODUK YANG DISERAHKAN</div>
            <table class="product-table">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Quantity</th>
                        <th class="text-right">Harga Satuan</th>
                        <th class="text-right">Total Harga</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ $order->product->product_title ?? 'N/A' }}</td>
                        <td>{{ $order->quantity }} unit</td>
                        <td class="text-right">Rp {{ number_format($order->price, 0, ',', '.') }}</td>
                        <td class="text-right">Rp {{ number_format($order->total_price, 0, ',', '.') }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <!-- Informasi Pembayaran -->
        @if($order->payment_method === 'dp')
            @php
                $dpPercentage = $order->dp_percentage ?? 30.00;
                $dpAmount = $order->total_price * ($dpPercentage / 100);
                $remainingAmount = $order->total_price - $dpAmount;
                
                if ($order->receivable) {
                    $paidAmount = $order->receivable->paid_amount ?? 0;
                    $remainingAmount = $order->receivable->remaining_amount ?? $remainingAmount;
                } else {
                    $paidAmount = $order->status === 'selesai' ? $order->total_price : $dpAmount;
                    $remainingAmount = $order->status === 'selesai' ? 0 : $remainingAmount;
                }
            @endphp
            <div class="handover-details">
                <div class="handover-title">RINCIAN PEMBAYARAN</div>
                <div class="handover-grid">
                    <div class="handover-left">
                        <div class="detail-row">
                            <div class="detail-label">Total Harga:</div>
                            <div class="detail-value">Rp {{ number_format($order->total_price, 0, ',', '.') }}</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">DP ({{ number_format($dpPercentage, 0) }}%):</div>
                            <div class="detail-value">Rp {{ number_format($dpAmount, 0, ',', '.') }}</div>
                        </div>
                    </div>
                    <div class="handover-right">
                        <div class="detail-row">
                            <div class="detail-label">Sudah Dibayar:</div>
                            <div class="detail-value">Rp {{ number_format($paidAmount, 0, ',', '.') }}</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Sisa Pembayaran:</div>
                            <div class="detail-value">Rp {{ number_format($remainingAmount, 0, ',', '.') }}</div>
                        </div>
                    </div>
                </div>
                @if($order->status === 'selesai')
                <div class="status-confirmed">
                    ✅ PEMBAYARAN LUNAS
                </div>
                @else
                <div style="background-color: #fff3cd; border: 2px solid #ffc107; padding: 10px; margin-top: 10px; border-radius: 5px; text-align: center; color: #856404; font-weight: bold; font-size: 12px;">
                    ⚠️ SISA PEMBAYARAN: Rp {{ number_format($remainingAmount, 0, ',', '.') }}
                </div>
                @endif
            </div>
        @else
            <div class="handover-details">
                <div class="handover-title">INFORMASI PEMBAYARAN</div>
                <div class="handover-grid">
                    <div class="handover-left">
                        <div class="detail-row">
                            <div class="detail-label">Total Harga:</div>
                            <div class="detail-value">Rp {{ number_format($order->total_price, 0, ',', '.') }}</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Metode Pembayaran:</div>
                            <div class="detail-value">{{ ucfirst($order->payment_method) }}</div>
                        </div>
                    </div>
                    <div class="handover-right">
                        <div class="detail-row">
                            <div class="detail-label">Status Pembayaran:</div>
                            <div class="detail-value">{{ $order->status_label }}</div>
                        </div>
                    </div>
                </div>
                @if($order->status === 'selesai')
                <div class="status-confirmed">
                    ✅ PEMBAYARAN LUNAS
                </div>
                @endif
            </div>
        @endif
        
        <!-- Foto Bukti Serah Terima -->
        @if($order->handover_photos && count($order->handover_photos) > 0)
        <div class="photos-section">
            <div class="section-title">FOTO BUKTI SERAH TERIMA</div>
            <div class="photo-grid">
                @foreach($order->handover_photos as $index => $photo)
                @php
                    // Path foto berdasarkan store('handover', 'uploads')
                    // File disimpan di: public/uploads/handover/...
                    $photoPath = public_path('uploads/' . $photo);
                    
                    // Convert to base64 untuk DomPDF
                    $imageData = '';
                    if (file_exists($photoPath)) {
                        $imageInfo = @getimagesize($photoPath);
                        $mimeType = $imageInfo ? $imageInfo['mime'] : 'image/jpeg';
                        $imageData = 'data:' . $mimeType . ';base64,' . base64_encode(file_get_contents($photoPath));
                    }
                @endphp
                @if($imageData)
                <div class="photo-item">
                    <img src="{{ $imageData }}" alt="Foto Serah Terima {{ $index + 1 }}">
                    <div class="photo-label">Foto {{ $index + 1 }}</div>
                </div>
                @endif
                @endforeach
            </div>
        </div>
        @endif
        
        <!-- Catatan Serah Terima -->
        @if($order->handover_notes)
        <div class="notes-section">
            <div class="notes-title">Catatan Serah Terima:</div>
            <div class="notes-content">
                {!! nl2br(e($order->handover_notes)) !!}
            </div>
        </div>
        @endif
        
        <!-- Hasil Produksi (jika ada) -->
        @if($order->production && ($order->production->result_photos || $order->production->test_results || $order->production->final_specifications))
        <div class="section">
            <div class="section-title">INFORMASI PRODUKSI</div>
            @if($order->production->final_specifications)
            <div class="notes-section">
                <div class="notes-title">Spesifikasi Produk:</div>
                <div class="notes-content">
                    {!! nl2br(e($order->production->final_specifications)) !!}
                </div>
            </div>
            @endif
            @if($order->production->test_results)
            <div class="notes-section" style="margin-top: 10px;">
                <div class="notes-title">Hasil Pengujian:</div>
                <div class="notes-content">
                    {!! nl2br(e($order->production->test_results)) !!}
                </div>
            </div>
            @endif
        </div>
        @endif
        
        <!-- Total -->
        <div class="total-section">
            <div class="total-row">
                <div class="total-label">Total Harga:</div>
                <div class="total-value">Rp {{ number_format($order->total_price, 0, ',', '.') }}</div>
            </div>
            @if($order->payment_method === 'dp' && $order->status !== 'selesai')
            <div class="total-row">
                <div class="total-label">Sisa Pembayaran:</div>
                <div class="total-value" style="color: #dc2626;">Rp {{ number_format($remainingAmount, 0, ',', '.') }}</div>
            </div>
            @endif
        </div>
        
        <!-- Syarat & Ketentuan -->
        <div style="margin-top: 30px; font-size: 10px; color: #666;">
            <strong>Syarat & Ketentuan:</strong><br>
            1. Produk telah diterima dalam kondisi baik dan sesuai spesifikasi<br>
            2. Garansi 1 tahun untuk mesin yang diproduksi<br>
            3. Service dan maintenance tersedia di workshop kami<br>
            4. Klaim garansi harus disertai dokumen ini<br>
            5. Dokumen ini berlaku sebagai bukti serah terima yang sah
        </div>
        
        <!-- Tanda Tangan -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-label">Yang Menerima</div>
                <div class="signature-line"></div>
                <div class="signature-name">({{ $order->customer_name }})</div>
                <div class="signature-date">{{ $order->customer_confirmed_at ? $order->customer_confirmed_at->format('d M Y') : 'Tanggal: ___________' }}</div>
            </div>
            <div class="signature-box">
                <div class="signature-label">Yang Menyerahkan</div>
                <div class="signature-line"></div>
                <div class="signature-name">({{ $order->handoverBy->name ?? 'Admin POLJAM TECH' }})</div>
                <div class="signature-date">{{ $order->handover_at ? $order->handover_at->format('d M Y') : now()->format('d M Y') }}</div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            Terima kasih atas kepercayaan Anda kepada POLJAM TECHNO WORKSHOP<br>
            Dokumen ini dicetak pada {{ now()->format('d M Y H:i') }}<br>
            <strong>Dokumen ini berlaku sebagai bukti serah terima produk yang sah</strong>
        </div>
    </div>
</body>
</html>

