@extends('layouts.admin')

@section('title', 'Perbarui Gambar')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.heroes.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Edit Hero Banner</h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <div class="p-6">

        <form action="{{ route('admin.heroes.update', $hero->id) }}" method="POST" enctype="multipart/form-data"
            class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Title -->
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Judul <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <input type="text" name="title" id="title" value="{{ old('title', $hero->title) }}"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('title') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan judul hero (kosongkan untuk menggunakan default)">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Jika kosong, akan menggunakan: "Solusi Mesin Teknologi Terdepan"</p>
                @error('title')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Subtitle -->
            <div>
                <label for="subtitle" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Subtitle <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <input type="text" name="subtitle" id="subtitle" value="{{ old('subtitle', $hero->subtitle) }}"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('subtitle') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan subtitle hero (kosongkan untuk menggunakan default)">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Jika kosong, akan menggunakan: "Untuk Semua Kebutuhan Bisnis & Industri Anda"</p>
                @error('subtitle')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Deskripsi <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <textarea name="description" id="description" rows="3"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('description') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan deskripsi hero (kosongkan untuk menggunakan default)">{{ old('description', $hero->description) }}</textarea>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Jika kosong, akan menggunakan: "Menyediakan berbagai mesin berkualitas tinggi untuk meningkatkan produktivitas bisnis Anda"</p>
                @error('description')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Image -->
            <div>
                <label for="image" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Gambar <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <div class="relative">
                    <input type="file" name="image" id="image" accept="image/*"
                        class="w-full px-4 py-3 text-sm text-gray-700 dark:text-gray-300 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900 dark:file:text-blue-200 @error('image') border-red-500 dark:border-red-500 @enderror">
                </div>
                @error('image')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror

                <!-- Preview -->
                <div class="mt-4">
                    <div class="flex items-center justify-center w-full h-64 bg-gray-50 dark:bg-gray-700/50 rounded-lg border-2 {{ $hero->image ? 'border-solid border-gray-200 dark:border-gray-600' : 'border-dashed border-gray-300 dark:border-gray-600' }}" id="previewContainer">
                        <img id="previewImage" class="max-w-full max-h-full object-contain rounded-lg" 
                             src="{{ $hero->image ? asset('uploads/' . $hero->image) : '' }}"
                             style="{{ $hero->image ? 'display: block; background: transparent;' : 'display: none; background: transparent;' }}">
                        <div id="previewPlaceholder" class="text-center" style="{{ $hero->image ? 'display: none;' : 'display: block;' }}">
                            <i class="fas fa-image text-4xl text-gray-400 dark:text-gray-500 mb-2"></i>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Preview gambar</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Order -->
            <div>
                <label for="order" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Urutan Tampil <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <input type="number" name="order" id="order" value="{{ old('order', $hero->order) }}" min="0"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('order') border-red-500 dark:border-red-500 @enderror"
                    placeholder="0">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Urutan untuk menampilkan hero (angka lebih kecil akan ditampilkan lebih dulu)</p>
                @error('order')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Is Active -->
            <div>
                <label class="flex items-center space-x-3">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $hero->is_active) ? 'checked' : '' }}
                        class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Aktifkan Hero</span>
                </label>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Hero yang tidak aktif tidak akan ditampilkan di halaman depan</p>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.heroes.index') }}"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Perbarui Hero Banner</span>
                </button>
            </div>
        </form>
        </div>
    </div>

    <!-- Script Preview Gambar -->
    <script>
        document.getElementById('image').addEventListener('change', function(event) {
            const file = event.target.files[0];
            const preview = document.getElementById('previewImage');
            const placeholder = document.getElementById('previewPlaceholder');
            const container = document.getElementById('previewContainer');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                };
                reader.readAsDataURL(file);
            } else {
                // Jika tidak ada file yang dipilih, kembali ke gambar asli atau placeholder
                const originalImage = '{{ $hero->image ? asset("uploads/" . $hero->image) : "" }}';
                if (originalImage) {
                    preview.src = originalImage;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                } else {
                    preview.src = '';
                    preview.style.display = 'none';
                    placeholder.style.display = 'block';
                    container.classList.add('border-dashed');
                    container.classList.remove('border-solid');
                }
            }
        });
    </script>
@endsection

