@extends('layouts.admin')

@section('title', $type === 'sparepart' ? 'Tambah Sparepart' : 'Tambah Bahan')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.master.materials.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">
                {{ $type === 'sparepart' ? 'Tambah Sparepart Baru' : 'Tambah Bahan Baru' }}
            </h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <form action="{{ route('admin.master.materials.store') }}" method="POST" enctype="multipart/form-data" class="p-5">
            @csrf
            <input type="hidden" name="type" value="{{ $type ?? 'material' }}">

            <div id="itemsContainer" class="space-y-5">
                @if(($type ?? 'material') === 'sparepart')
                    @include('admin.master.materials.partials.sparepart-form', ['index' => 0])
                @else
                    @include('admin.master.materials.partials.material-form', ['index' => 0])
                @endif
            </div>

            <!-- Add Item Button -->
            <div class="flex justify-center my-6">
                <button type="button" id="addItemBtn"
                    class="flex items-center bg-blue-500 hover:bg-blue-600 text-white font-medium px-6 py-3 rounded-lg transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>
                    <span>{{ $type === 'sparepart' ? 'Tambah Sparepart Lain' : 'Tambah Bahan Lain' }}</span>
                </button>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.master.materials.index') }}"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Simpan</span>
                </button>
            </div>
        </form>
    </div>

    <script>
        const itemType = '{{ $type ?? 'material' }}';
        let itemIndex = 1;

        document.getElementById('addItemBtn').addEventListener('click', function() {
            const container = document.getElementById('itemsContainer');
            const div = document.createElement('div');
            div.className = "bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 relative";
            
            if (itemType === 'sparepart') {
                div.innerHTML = getSparepartFormHTML(itemIndex);
            } else {
                div.innerHTML = getMaterialFormHTML(itemIndex);
            }
            
            container.appendChild(div);
            itemIndex++;
        });

        function getMaterialFormHTML(index) {
            return `
                <button type="button" class="absolute top-4 right-4 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200" onclick="removeItem(this)">
                    <i class="fas fa-times text-sm"></i>
                </button>
                <div class="flex items-center mb-5">
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Bahan</h3>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Bahan</label>
                        <input type="text" name="materials[${index}][material_code]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Jika kosong, otomatis dibuat unik">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Nama Bahan <span class="text-red-500">*</span></label>
                        <input type="text" name="materials[${index}][name]" required class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Masukkan nama bahan">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kategori</label>
                        <input type="text" name="materials[${index}][category]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Masukkan kategori bahan">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Stok <span class="text-red-500">*</span></label>
                        <input type="number" name="materials[${index}][stock]" min="0" required class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="0">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
                        <input type="text" name="materials[${index}][unit]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="cth: kg, liter, meter">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Harga Satuan (Rp)</label>
                        <input type="number" name="materials[${index}][price]" min="0" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="cth: 15000">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Supplier</label>
                        <input type="text" name="materials[${index}][supplier]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Jika kosong, otomatis '-'">
                    </div>
                </div>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
                        <textarea name="materials[${index}][description]" rows="4" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm" placeholder="Tuliskan deskripsi bahan jika perlu..."></textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
                        <div class="space-y-3">
                            <input type="file" name="materials[${index}][image]" accept="image/*" onchange="previewImage(this)" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                            <div class="relative inline-block w-full max-w-xs">
                                <img src="" alt="Preview" class="w-full h-48 object-contain rounded-lg border border-gray-200 dark:border-gray-600 bg-gray-50 dark:bg-gray-700/50 hidden" style="background: transparent;">
                                <button type="button" onclick="removeImage(this)" class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 hidden">
                                    <i class="fas fa-times text-sm"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex items-center">
                    <input type="checkbox" name="materials[${index}][is_active]" value="1" checked class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
                    <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
                </div>
            `;
        }

        function getSparepartFormHTML(index) {
            return `
                <button type="button" class="absolute top-4 right-4 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200" onclick="removeItem(this)">
                    <i class="fas fa-times text-sm"></i>
                </button>
                <div class="flex items-center mb-5">
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Sparepart</h3>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Sparepart</label>
                        <input type="text" name="spareparts[${index}][part_code]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Jika kosong, otomatis dibuat unik">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Nama Sparepart <span class="text-red-500">*</span></label>
                        <input type="text" name="spareparts[${index}][name]" required class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Masukkan nama sparepart">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Brand</label>
                        <input type="text" name="spareparts[${index}][brand]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Merk / brand">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tipe</label>
                        <input type="text" name="spareparts[${index}][type]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Tipe sparepart">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Part Number</label>
                        <input type="text" name="spareparts[${index}][part_number]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="Nomor part">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Stok <span class="text-red-500">*</span></label>
                        <input type="number" name="spareparts[${index}][stock]" min="0" required class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="0">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
                        <input type="text" name="spareparts[${index}][unit]" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="cth: pcs, unit, set">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Harga Satuan (Rp)</label>
                        <input type="number" name="spareparts[${index}][price]" min="0" step="0.01" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm" placeholder="cth: 50000">
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" name="spareparts[${index}][is_active]" value="1" checked class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
                        <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
                    </div>
                </div>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
                        <textarea name="spareparts[${index}][description]" rows="4" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm" placeholder="Tuliskan deskripsi sparepart jika perlu..."></textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
                        <div class="space-y-3">
                            <input type="file" name="spareparts[${index}][image]" accept="image/*" onchange="previewImage(this)" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                            <div class="relative inline-block w-full max-w-xs">
                                <img src="" alt="Preview" class="w-full h-48 object-contain rounded-lg border border-gray-200 dark:border-gray-600 bg-gray-50 dark:bg-gray-700/50 hidden" style="background: transparent;">
                                <button type="button" onclick="removeImage(this)" class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 hidden">
                                    <i class="fas fa-times text-sm"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        function removeItem(button) {
            button.closest('div.bg-white').remove();
        }

        function previewImage(input) {
            const file = input.files[0];
            const previewContainer = input.parentElement.querySelector('div');
            const img = previewContainer ? previewContainer.querySelector('img') : null;
            const removeBtn = previewContainer ? previewContainer.querySelector('button') : null;

            if (file && img && removeBtn) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    img.src = e.target.result;
                    img.classList.remove('hidden');
                    removeBtn.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else if (img && removeBtn) {
                img.src = '';
                img.classList.add('hidden');
                removeBtn.classList.add('hidden');
            }
        }

        function removeImage(button) {
            const container = button.closest('div');
            const img = container.querySelector('img');
            const input = container.parentElement.parentElement.querySelector('input[type=file]');

            if (input) {
                input.value = '';
            }
            if (img) {
                img.src = '';
                img.classList.add('hidden');
            }
            if (button) {
                button.classList.add('hidden');
            }
        }
    </script>
@endsection
