<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dokumen Spesifikasi Teknis - {{ $product->product_title }}</title>
    <style>
        @page {
            margin: 1.5cm;
        }

        body {
            font-family: "Times New Roman", Times, serif;
            color: #000;
            font-size: 11pt;
            line-height: 1.4;
        }

        .container {
            width: 100%;
        }

        .header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #000;
        }

        .logo-placeholder {
            width: 80px;
            height: 80px;
            border: 2px solid #000;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 9pt;
            text-align: center;
        }

        .header-text {
            flex: 1;
        }

        .company-name {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .company-detail {
            font-size: 10pt;
            margin-bottom: 2px;
        }

        .document-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            margin: 20px 0 15px 0;
        }

        .section {
            margin-top: 15px;
        }

        .section-title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 8px;
            padding: 5px 8px;
            background-color: #f0f0f0;
            border-left: 4px solid #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10pt;
            margin-top: 5px;
        }

        table.info-table {
            border: 1px solid #000;
        }

        table.info-table th,
        table.info-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: left;
        }

        table.info-table th {
            background-color: #f5f5f5;
            font-weight: bold;
            width: 30%;
        }

        table.data-table {
            border: 1px solid #000;
        }

        table.data-table th,
        table.data-table td {
            border: 1px solid #000;
            padding: 5px 6px;
            text-align: left;
        }

        table.data-table th {
            background-color: #e8e8e8;
            font-weight: bold;
            text-align: center;
        }

        table.data-table td {
            text-align: left;
        }

        table.data-table td.text-center {
            text-align: center;
        }

        table.data-table td.text-right {
            text-align: right;
        }

        .highlight {
            background-color: #ffff00;
            padding: 2px 4px;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .footer-note {
            margin-top: 20px;
            font-size: 9pt;
            color: #666;
            font-style: italic;
        }

        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }

            .no-print {
                display: none;
            }
        }

        @media screen {
            body {
                background-color: #f5f5f5;
                padding: 20px;
            }

            .container {
                background-color: white;
                padding: 30px;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                max-width: 210mm;
                margin: 0 auto;
            }

            .print-actions {
                text-align: center;
                margin-bottom: 20px;
                padding: 15px;
                background-color: #f0f0f0;
                border-radius: 5px;
            }

            .print-actions button {
                padding: 10px 20px;
                margin: 0 5px;
                font-size: 14px;
                cursor: pointer;
                border: none;
                border-radius: 5px;
                background-color: #007bff;
                color: white;
            }

            .print-actions button:hover {
                background-color: #0056b3;
            }
        }
    </style>
    @php
        function rupiah($n)
        {
            return 'Rp ' . number_format($n ?? 0, 0, ',', '.');
        }

        // Data fake untuk bahan (jika belum ada di database)
        $fakeMaterials = [
            [
                'name' => 'Besi Hollow 40x40',
                'code' => 'BH-4040',
                'quantity' => 12,
                'unit' => 'batang',
                'type' => 'Bahan Utama',
                'cost' => 450000,
            ],
            [
                'name' => 'Plat Besi 3mm',
                'code' => 'PB-3MM',
                'quantity' => 8,
                'unit' => 'lembar',
                'type' => 'Bahan Utama',
                'cost' => 320000,
            ],
            [
                'name' => 'Stainless Steel 304',
                'code' => 'SS-304',
                'quantity' => 15,
                'unit' => 'kg',
                'type' => 'Bahan Utama',
                'cost' => 675000,
            ],
            [
                'name' => 'Baut M8x25',
                'code' => 'BT-M825',
                'quantity' => 50,
                'unit' => 'pcs',
                'type' => 'Pengikat',
                'cost' => 125000,
            ],
            [
                'name' => 'Mur M8',
                'code' => 'MR-M8',
                'quantity' => 50,
                'unit' => 'pcs',
                'type' => 'Pengikat',
                'cost' => 75000,
            ],
            [
                'name' => 'Cat Epoxy Biru',
                'code' => 'CE-BIRU',
                'quantity' => 3,
                'unit' => 'kaleng',
                'type' => 'Finishing',
                'cost' => 450000,
            ],
            [
                'name' => 'Dinamo Listrik 1 HP',
                'code' => 'DN-1HP',
                'quantity' => 1,
                'unit' => 'unit',
                'type' => 'Komponen',
                'cost' => 1200000,
            ],
            [
                'name' => 'Bearing 6205',
                'code' => 'BR-6205',
                'quantity' => 4,
                'unit' => 'pcs',
                'type' => 'Komponen',
                'cost' => 320000,
            ],
            [
                'name' => 'Kabel Listrik NYA 2.5mm',
                'code' => 'KB-25',
                'quantity' => 20,
                'unit' => 'meter',
                'type' => 'Elektrik',
                'cost' => 180000,
            ],
            [
                'name' => 'Saklar ON/OFF',
                'code' => 'SK-ONOFF',
                'quantity' => 1,
                'unit' => 'pcs',
                'type' => 'Elektrik',
                'cost' => 85000,
            ],
        ];

        // Data fake untuk sparepart (jika belum ada di database)
        $fakeSpareparts = [
            [
                'name' => 'Gear Reducer 1:30',
                'type' => 'Transmisi',
                'brand' => 'NORD',
                'part_no' => 'NORD-GR-130',
                'quantity' => 1,
                'unit' => 'unit',
                'cost' => 2500000,
            ],
            [
                'name' => 'V-Belt A-50',
                'type' => 'Transmisi',
                'brand' => 'Bando',
                'part_no' => 'BND-VB-A50',
                'quantity' => 2,
                'unit' => 'pcs',
                'cost' => 180000,
            ],
            [
                'name' => 'Pulley 4 Inch',
                'type' => 'Transmisi',
                'brand' => 'Standard',
                'part_no' => 'STD-PLY-4IN',
                'quantity' => 2,
                'unit' => 'pcs',
                'cost' => 320000,
            ],
            [
                'name' => 'Seal Shaft 25mm',
                'type' => 'Seal',
                'brand' => 'NOK',
                'part_no' => 'NOK-SL-25',
                'quantity' => 2,
                'unit' => 'pcs',
                'cost' => 150000,
            ],
            [
                'name' => 'O-Ring 25x3',
                'type' => 'Seal',
                'brand' => 'NOK',
                'part_no' => 'NOK-OR-25X3',
                'quantity' => 4,
                'unit' => 'pcs',
                'cost' => 80000,
            ],
            [
                'name' => 'Bearing 6206',
                'type' => 'Bearing',
                'brand' => 'SKF',
                'part_no' => 'SKF-BR-6206',
                'quantity' => 2,
                'unit' => 'pcs',
                'cost' => 450000,
            ],
            [
                'name' => 'Thermal Overload Relay',
                'type' => 'Elektrik',
                'brand' => 'Schneider',
                'part_no' => 'SCH-TOR-10A',
                'quantity' => 1,
                'unit' => 'pcs',
                'cost' => 350000,
            ],
            [
                'name' => 'Contact Switch',
                'type' => 'Elektrik',
                'brand' => 'Omron',
                'part_no' => 'OMR-CS-24V',
                'quantity' => 2,
                'unit' => 'pcs',
                'cost' => 280000,
            ],
        ];

        // Merge dengan data real jika ada
        $allMaterials =
            $product->materials && $product->materials->count() > 0
                ? $product->materials
                    ->map(function ($m) {
                        return [
                            'name' => $m->name,
                            'code' => $m->code ?? '-',
                            'quantity' => $m->quantity,
                            'unit' => $m->unit,
                            'type' => $m->type ?? 'Bahan Utama',
                            'cost' => $m->usage_cost,
                        ];
                    })
                    ->toArray()
                : $fakeMaterials;

        $allSpareparts =
            $product->spareparts && $product->spareparts->count() > 0
                ? $product->spareparts
                    ->map(function ($s) {
                        return [
                            'name' => $s->name,
                            'type' => $s->type ?? 'Sparepart',
                            'brand' => $s->brand ?? '-',
                            'part_no' => $s->part_no ?? '-',
                            'quantity' => $s->quantity,
                            'unit' => $s->unit,
                            'cost' => $s->usage_cost,
                        ];
                    })
                    ->toArray()
                : $fakeSpareparts;

        $totalMaterialCost = array_sum(array_column($allMaterials, 'cost'));
        $totalSparepartCost = array_sum(array_column($allSpareparts, 'cost'));
        $serviceFee = $product->service_fee ?? 0;
        $totalProductionCost = $totalMaterialCost + $totalSparepartCost + $serviceFee;
        $productPrice = $product->product_prices ?? 0;
    @endphp
</head>

<body>
    <div class="container">
        <!-- Print Actions (only visible on screen) -->
        <div class="print-actions no-print">
            <button onclick="window.print()">
                <i class="fas fa-print"></i> Print / Save as PDF
            </button>
            <button onclick="window.close()" style="background-color: #6c757d;">
                <i class="fas fa-times"></i> Tutup
            </button>
        </div>

        <!-- Header -->
        <div class="header">
            <div class="logo-placeholder">
                LOGO<br>POLJAMTECH
            </div>
            <div class="header-text">
                <div class="company-name">POLJAMTECH</div>
                <div class="company-detail">PERUSAHAAN TEKNOLOGI DAN MANUFAKTUR</div>
                <div class="company-detail">Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete</div>
                <div class="company-detail">Kec. Alam Barajo, Kota Jambi</div>
                <div class="company-detail" style="margin-top: 5px; font-weight: bold;">PEJABAT PENGADAAN BARANG/JASA
                </div>
            </div>
        </div>

        <!-- Document Title -->
        <div class="document-title">
            DOKUMEN SPESIFIKASI TEKNIS<br>
            PENGADAAN BARANG
        </div>

        <!-- Paket Pengadaan -->
        <div class="section">
            <table class="info-table">
                <tr>
                    <th>PAKET PENGADAAN</th>
                    <td><strong>{{ strtoupper($product->product_title) }}</strong></td>
                </tr>
                <tr>
                    <th>PPK</th>
                    <td>POLJAMTECH</td>
                </tr>
                <tr>
                    <th>ID PRODUK</th>
                    <td>#{{ $product->id }}</td>
                </tr>
            </table>
        </div>

        <!-- Spesifikasi Fungsi Umum -->
        <div class="section">
            <div class="section-title">SPESIFIKASI FUNGSI UMUM</div>
            <table class="info-table">
                <tr>
                    <th>Fungsi Utama</th>
                    <td>{{ $product->product_description ?? 'Mesin produksi untuk meningkatkan efisiensi dan produktivitas industri' }}
                    </td>
                </tr>
                <tr>
                    <th>Kategori Produk</th>
                    <td>{{ $product->category->name ?? '-' }}</td>
                </tr>
            </table>
        </div>

        <!-- Spesifikasi Mutu/Kualitas -->
        <div class="section">
            <div class="section-title">SPESIFIKASI MUTU/KUALITAS</div>
            <p style="margin-bottom: 8px;"><strong>Berdasarkan Spesifikasi Teknis:</strong></p>
            <p style="margin-bottom: 8px;"><strong>{{ $product->product_title }}</strong></p>

            @if ($product->specifications && $product->specifications->count() > 0)
                <table class="data-table" style="margin-top: 10px;">
                    <thead>
                        <tr>
                            <th style="width: 35%;">Spesifikasi</th>
                            <th>Nilai</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($product->specifications as $spec)
                            <tr>
                                <td><strong>{{ $spec->key }}</strong></td>
                                <td>{{ $spec->value }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <table class="info-table" style="margin-top: 10px;">
                    <tr>
                        <th>Jenis Mesin</th>
                        <td>{{ $product->product_title }}</td>
                    </tr>
                    <tr>
                        <th>Kapasitas</th>
                        <td>Menyesuaikan kebutuhan produksi</td>
                    </tr>
                    <tr>
                        <th>Daya Listrik</th>
                        <td>Menyesuaikan spesifikasi teknis</td>
                    </tr>
                    <tr>
                        <th>Material Utama</th>
                        <td>Besi, Stainless Steel, dan komponen berkualitas</td>
                    </tr>
                </table>
            @endif
        </div>

        <!-- Spesifikasi Jumlah -->
        <div class="section">
            <div class="section-title">SPESIFIKASI JUMLAH</div>
            <p style="margin-bottom: 8px;">Untuk pengadaan barang:</p>
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 60%;">Uraian Barang</th>
                        <th style="width: 15%;">Satuan</th>
                        <th style="width: 20%;">Volume</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center">1</td>
                        <td><strong>{{ $product->product_title }}</strong></td>
                        <td class="text-center">Unit</td>
                        <td class="text-center">1</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Daftar Bahan yang Digunakan -->
        @if (!empty($allMaterials))
            <div class="section">
                <div class="section-title">DAFTAR BAHAN YANG DIGUNAKAN</div>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th style="width: 5%;">No</th>
                            <th style="width: 15%;">Kode</th>
                            <th style="width: 40%;">Nama Bahan</th>
                            <th style="width: 10%;">Jumlah</th>
                            <th style="width: 10%;">Satuan</th>
                            <th style="width: 20%;" class="text-right">Biaya (Rp)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($allMaterials as $index => $material)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td>{{ $material['code'] }}</td>
                                <td>{{ $material['name'] }}</td>
                                <td class="text-center">{{ $material['quantity'] }}</td>
                                <td class="text-center">{{ $material['unit'] }}</td>
                                <td class="text-right">{{ rupiah($material['cost']) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background-color: #f0f0f0; font-weight: bold;">
                            <td colspan="5" class="text-right">Total Biaya Bahan:</td>
                            <td class="text-right">{{ rupiah($totalMaterialCost) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif

        <!-- Daftar Sparepart yang Digunakan -->
        @if (!empty($allSpareparts))
            <div class="section">
                <div class="section-title">DAFTAR SPAREPART YANG DIGUNAKAN</div>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th style="width: 5%;">No</th>
                            <th style="width: 15%;">No. Part</th>
                            <th style="width: 30%;">Nama Sparepart</th>
                            <th style="width: 15%;">Merek</th>
                            <th style="width: 10%;">Jumlah</th>
                            <th style="width: 10%;">Satuan</th>
                            <th style="width: 15%;" class="text-right">Biaya (Rp)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($allSpareparts as $index => $sparepart)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td>{{ $sparepart['part_no'] }}</td>
                                <td>{{ $sparepart['name'] }}</td>
                                <td>{{ $sparepart['brand'] }}</td>
                                <td class="text-center">{{ $sparepart['quantity'] }}</td>
                                <td class="text-center">{{ $sparepart['unit'] }}</td>
                                <td class="text-right">{{ rupiah($sparepart['cost']) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background-color: #f0f0f0; font-weight: bold;">
                            <td colspan="6" class="text-right">Total Biaya Sparepart:</td>
                            <td class="text-right">{{ rupiah($totalSparepartCost) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif

        <!-- Spesifikasi Waktu -->
        <div class="section">
            <div class="section-title">SPESIFIKASI WAKTU</div>
            <table class="info-table">
                <tr>
                    <th class="highlight">Jangka kedatangan barang/jasa (untuk pengadaan barang)</th>
                    <td><strong>{{ $product->product_work_duration ?? '2 (Dua) Minggu' }}</strong></td>
                </tr>
                <tr>
                    <th class="highlight">Lokasi kedatangan barang</th>
                    <td>Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</td>
                </tr>
                <tr>
                    <th class="highlight">Metode transportasi dan pengepakan (jika ditentukan)</th>
                    <td>Transportasi Darat dengan pengemasan yang aman dan rapi</td>
                </tr>
            </table>
        </div>

        <!-- Spesifikasi Garansi -->
        @if ($product->product_garansi)
            <div class="section">
                <div class="section-title">SPESIFIKASI GARANSI</div>
                <table class="info-table">
                    <tr>
                        <th>Periode Garansi</th>
                        <td><strong>{{ $product->product_garansi }}</strong></td>
                    </tr>
                    <tr>
                        <th>Jenis Garansi</th>
                        <td>Garansi suku cadang dan jasa perbaikan</td>
                    </tr>
                </table>
            </div>
        @endif

        <!-- Ringkasan Biaya -->
        <div class="section">
            <div class="section-title">RINGKASAN BIAYA</div>
            <table class="info-table">
                <tr>
                    <th>Harga Jual Produk</th>
                    <td class="text-right"><strong>{{ rupiah($productPrice) }}</strong></td>
                </tr>
                <tr>
                    <th>Upah Jasa Pengerjaan</th>
                    <td class="text-right">{{ rupiah($serviceFee) }}</td>
                </tr>
                <tr>
                    <th>Total Biaya Bahan</th>
                    <td class="text-right">{{ rupiah($totalMaterialCost) }}</td>
                </tr>
                <tr>
                    <th>Total Biaya Sparepart</th>
                    <td class="text-right">{{ rupiah($totalSparepartCost) }}</td>
                </tr>
                <tr style="background-color: #f0f0f0; font-weight: bold;">
                    <th>Total Biaya Produksi</th>
                    <td class="text-right">{{ rupiah($totalProductionCost) }}</td>
                </tr>
            </table>
        </div>

        <!-- Footer Note -->
        <div class="footer-note">
            <p><strong>Catatan:</strong> Dokumen ini merupakan spesifikasi teknis resmi untuk pengadaan barang. Harga
                dan spesifikasi dapat berubah sesuai dengan kondisi dan kebutuhan aktual.</p>
            <p style="margin-top: 15px; text-align: right;">
                Jambi, {{ date('d F Y') }}<br>
                <strong>POLJAMTECH</strong>
            </p>
        </div>
    </div>

    <script>
        // Auto print jika parameter print=1
        if (window.location.search.includes('print=1')) {
            window.onload = function() {
                window.print();
            };
        }
    </script>
</body>

</html>
