<!-- Quick Stats & Customer Info -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-4 lg:gap-6 mb-6">
    <!-- Customer Statistics -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-users text-blue-600 dark:text-blue-400 mr-2"></i>
                Statistik Customer
            </h3>
        </div>
        <div class="space-y-4">
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-medium text-blue-700 dark:text-blue-300 mb-1 uppercase tracking-wide">Total Customer</p>
                        <p class="text-2xl font-bold text-blue-900 dark:text-blue-200">{{ $stats['total_customers'] ?? 0 }}</p>
                    </div>
                    <div class="bg-blue-500 rounded-lg p-3">
                        <i class="fas fa-user-friends text-white text-lg"></i>
                    </div>
                </div>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-medium text-green-700 dark:text-green-300 mb-1 uppercase tracking-wide">Customer Baru</p>
                        <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['new_customers_this_month'] ?? 0 }}</p>
                        <p class="text-xs text-green-600 dark:text-green-400 mt-1">Bulan ini</p>
                    </div>
                    <div class="bg-green-500 rounded-lg p-3">
                        <i class="fas fa-user-plus text-white text-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Profit Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-chart-line text-green-600 dark:text-green-400 mr-2"></i>
                Ringkasan Keuntungan
            </h3>
        </div>
        <div class="space-y-4">
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-medium text-green-700 dark:text-green-300 uppercase tracking-wide">Gross Profit</p>
                    <i class="fas fa-arrow-up text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200 mb-1">
                    Rp {{ number_format($stats['gross_profit'] ?? 0, 0, ',', '.') }}
                </p>
                <p class="text-xs text-green-600 dark:text-green-400">Penjualan - Pembelian</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-medium text-blue-700 dark:text-blue-300 uppercase tracking-wide">Net Profit</p>
                    <i class="fas fa-chart-bar text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-blue-900 dark:text-blue-200 mb-1">
                    Rp {{ number_format($stats['net_profit'] ?? 0, 0, ',', '.') }}
                </p>
                <p class="text-xs text-blue-600 dark:text-blue-400">Gross Profit - Biaya Produksi</p>
            </div>
            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <p class="text-xs font-medium text-gray-700 dark:text-gray-300">Total Biaya Produksi</p>
                    <p class="text-lg font-bold text-gray-900 dark:text-white">
                        Rp {{ number_format($stats['total_production_costs'] ?? 0, 0, ',', '.') }}
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Pending Tasks -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-tasks text-red-600 dark:text-red-400 mr-2"></i>
                Tugas Menunggu
            </h3>
            @if(($stats['total_pending_tasks'] ?? 0) > 0)
            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 text-sm font-bold">
                {{ $stats['total_pending_tasks'] ?? 0 }}
            </span>
            @endif
        </div>
        <div class="space-y-3">
            @if(($stats['pending_tasks']['unread_orders'] ?? 0) > 0)
            <a href="{{ route('admin.master.orders.index', ['is_read' => 0]) }}" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg transition-all border border-yellow-200 dark:border-yellow-800 group">
                <div class="flex items-center">
                    <div class="bg-yellow-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-envelope text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-yellow-900 dark:text-yellow-200">Order Belum Dibaca</span>
                </div>
                <span class="text-lg font-bold text-yellow-900 dark:text-yellow-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg">{{ $stats['pending_tasks']['unread_orders'] ?? 0 }}</span>
            </a>
            @endif

            @if(($stats['pending_tasks']['pending_handover'] ?? 0) > 0)
            <a href="{{ route('admin.handover.index', ['status' => 'delivered']) }}" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-amber-50 to-amber-100 dark:from-amber-900/20 dark:to-amber-900/10 rounded-lg transition-all border border-amber-200 dark:border-amber-800 group">
                <div class="flex items-center">
                    <div class="bg-amber-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-handshake text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-amber-900 dark:text-amber-200">Menunggu Konfirmasi Customer</span>
                </div>
                <span class="text-lg font-bold text-amber-900 dark:text-amber-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg">{{ $stats['pending_tasks']['pending_handover'] ?? 0 }}</span>
            </a>
            @endif

            @if(($stats['pending_tasks']['pending_production_approvals'] ?? 0) > 0)
            <a href="{{ route('supervisor.productions.index', ['planning_status' => 'pending_approval']) }}" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg transition-all border border-blue-200 dark:border-blue-800 group">
                <div class="flex items-center">
                    <div class="bg-blue-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-clipboard-check text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-blue-900 dark:text-blue-200">Planning Menunggu Approval</span>
                </div>
                <span class="text-lg font-bold text-blue-900 dark:text-blue-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg">{{ $stats['pending_tasks']['pending_production_approvals'] ?? 0 }}</span>
            </a>
            @endif

            @if(($stats['pending_tasks']['pending_completion_approvals'] ?? 0) > 0)
            <a href="{{ route('supervisor.productions.index', ['completion_status' => 'pending_approval']) }}" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-indigo-50 to-indigo-100 dark:from-indigo-900/20 dark:to-indigo-900/10 rounded-lg transition-all border border-indigo-200 dark:border-indigo-800 group">
                <div class="flex items-center">
                    <div class="bg-indigo-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-check-double text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-indigo-900 dark:text-indigo-200">Completion Menunggu Approval</span>
                </div>
                <span class="text-lg font-bold text-indigo-900 dark:text-indigo-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg">{{ $stats['pending_tasks']['pending_completion_approvals'] ?? 0 }}</span>
            </a>
            @endif

            @if(($stats['total_pending_tasks'] ?? 0) === 0)
            <div class="text-center py-8">
                <div class="w-16 h-16 mx-auto mb-3 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-2xl"></i>
                </div>
                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Tidak ada tugas menunggu</p>
            </div>
            @endif
        </div>
    </div>
</div>


