<!-- Status Summaries Section -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Order Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400 mr-2"></i>
                Status Pesanan
            </h3>
            <a href="{{ route('admin.master.orders.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg border border-yellow-200 dark:border-yellow-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-yellow-700 dark:text-yellow-300 uppercase tracking-wide">Menunggu</p>
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-yellow-900 dark:text-yellow-200">{{ $stats['order_status_summary']['menunggu'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-blue-700 dark:text-blue-300 uppercase tracking-wide">Diterima</p>
                    <i class="fas fa-check-circle text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-blue-900 dark:text-blue-200">{{ $stats['order_status_summary']['diterima'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900/20 dark:to-red-900/10 rounded-lg border border-red-200 dark:border-red-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-red-700 dark:text-red-300 uppercase tracking-wide">Ditolak</p>
                    <i class="fas fa-times-circle text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-red-900 dark:text-red-200">{{ $stats['order_status_summary']['ditolak'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Selesai</p>
                    <i class="fas fa-check-double text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['order_status_summary']['selesai'] ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Production Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Status Produksi
            </h3>
            <a href="{{ route('admin.productions.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-700/30 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wide">Menunggu</p>
                    <i class="fas fa-hourglass-half text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['production_status_summary']['menunggu'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-indigo-50 to-indigo-100 dark:from-indigo-900/20 dark:to-indigo-900/10 rounded-lg border border-indigo-200 dark:border-indigo-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-indigo-700 dark:text-indigo-300 uppercase tracking-wide">Dalam Proses</p>
                    <i class="fas fa-cog text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-indigo-900 dark:text-indigo-200">{{ $stats['production_status_summary']['dalam_proses'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Selesai</p>
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['production_status_summary']['selesai'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900/20 dark:to-red-900/10 rounded-lg border border-red-200 dark:border-red-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-red-700 dark:text-red-300 uppercase tracking-wide">Dibatalkan</p>
                    <i class="fas fa-ban text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-red-900 dark:text-red-200">{{ $stats['production_status_summary']['dibatalkan'] ?? 0 }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Handover & Payment Status Summary -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Handover Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-handshake text-amber-600 dark:text-amber-400 mr-2"></i>
                Status Serah Terima
            </h3>
            <a href="{{ route('admin.handover.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-700/30 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wide">Pending</p>
                    <i class="fas fa-clock text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['handover_status_summary']['pending'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-blue-700 dark:text-blue-300 uppercase tracking-wide">Siap</p>
                    <i class="fas fa-box text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-blue-900 dark:text-blue-200">{{ $stats['handover_status_summary']['ready'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-amber-50 to-amber-100 dark:from-amber-900/20 dark:to-amber-900/10 rounded-lg border border-amber-200 dark:border-amber-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-amber-700 dark:text-amber-300 uppercase tracking-wide">Diserahkan</p>
                    <i class="fas fa-truck text-amber-600 dark:text-amber-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-amber-900 dark:text-amber-200">{{ $stats['handover_status_summary']['delivered'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Dikonfirmasi</p>
                    <i class="fas fa-check-double text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['handover_status_summary']['confirmed'] ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Payment Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-credit-card text-purple-600 dark:text-purple-400 mr-2"></i>
                Status Pembayaran
            </h3>
            <a href="{{ route('admin.master.orders.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg border border-yellow-200 dark:border-yellow-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-yellow-700 dark:text-yellow-300 uppercase tracking-wide">Menunggu Verifikasi</p>
                    <i class="fas fa-hourglass-half text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-yellow-900 dark:text-yellow-200">{{ $stats['payment_status_summary']['menunggu_verifikasi'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-blue-700 dark:text-blue-300 uppercase tracking-wide">Diproses</p>
                    <i class="fas fa-spinner text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-blue-900 dark:text-blue-200">{{ $stats['payment_status_summary']['diproses'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Selesai</p>
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['payment_status_summary']['selesai'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900/20 dark:to-red-900/10 rounded-lg border border-red-200 dark:border-red-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-red-700 dark:text-red-300 uppercase tracking-wide">Gagal</p>
                    <i class="fas fa-times-circle text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-red-900 dark:text-red-200">{{ $stats['payment_status_summary']['gagal'] ?? 0 }}</p>
            </div>
        </div>
    </div>
</div>

