<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Quotation Offer</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 24px; }
        h1, h2, h3 { margin: 0 0 8px 0; }
        .header { text-align: center; margin-bottom: 16px; }
        .meta, .terms { margin: 12px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f3f4f6; }
        .right { text-align: right; }
        .small { font-size: 11px; color: #374151; }
        .muted { color: #6b7280; }
    </style>
    </head>
<body>
    <div class="header">
        <h2>Penawaran Harga (Quotation)</h2>
        <div class="small">Kode: {{ $inquiry->tracking_code ?? ('INQ-'.$inquiry->id) }}</div>
        <div class="small">Tanggal: {{ now()->format('d/m/Y') }}</div>
    </div>

    <div class="meta">
        <table>
            <tr>
                <th style="width: 30%">Customer</th>
                <td>{{ $inquiry->name }} ({{ $inquiry->email }})</td>
            </tr>
            <tr>
                <th>Produk</th>
                <td>{{ $inquiry->product->product_title ?? '-' }}</td>
            </tr>
            <tr>
                <th>Qty</th>
                <td>1 unit</td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th>Uraian</th>
                <th class="right">Harga</th>
            </tr>
        </thead>
        <tbody>
            @php
                $materialsTotal = $inquiry->materials_total_cost ?? null;
                $sparepartsTotal = $inquiry->spareparts_total_cost ?? null;
                $laborTotal = $inquiry->labor_cost_total ?? $inquiry->labor_cost ?? null;
                $finalOffer = $inquiry->final_offer_price ?? $inquiry->final_price ?? 0;
            @endphp
            @if(!is_null($materialsTotal) || !is_null($sparepartsTotal) || !is_null($laborTotal))
            <tr>
                <td>Material</td>
                <td class="right">{{ is_null($materialsTotal) ? '-' : ('Rp ' . number_format($materialsTotal, 0, ',', '.')) }}</td>
            </tr>
            <tr>
                <td>Sparepart</td>
                <td class="right">{{ is_null($sparepartsTotal) ? '-' : ('Rp ' . number_format($sparepartsTotal, 0, ',', '.')) }}</td>
            </tr>
            <tr>
                <td>Jasa (Tenaga Kerja)</td>
                <td class="right">{{ is_null($laborTotal) ? '-' : ('Rp ' . number_format($laborTotal, 0, ',', '.')) }}</td>
            </tr>
            <tr>
                <td class="muted small">Subtotal Biaya Internal</td>
                <td class="right muted small">
                    @php
                        $subtotalInternal = (float)($materialsTotal ?? 0) + (float)($sparepartsTotal ?? 0) + (float)($laborTotal ?? 0);
                    @endphp
                    {{ $subtotalInternal > 0 ? ('Rp ' . number_format($subtotalInternal, 0, ',', '.')) : '-' }}
                </td>
            </tr>
            @endif
            <tr>
                <td>Harga Penawaran Final</td>
                <td class="right">Rp {{ number_format($finalOffer, 0, ',', '.') }}</td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <th>Total</th>
                <th class="right">Rp {{ number_format($finalOffer, 0, ',', '.') }}</th>
            </tr>
        </tfoot>
    </table>

    <div class="terms">
        <h3>Ketentuan</h3>
        <ul class="small">
            <li>Lead time (estimasi): {{ $inquiry->lead_time_days ? $inquiry->lead_time_days.' hari' : '-' }}</li>
            <li>Masa berlaku penawaran: {{ $inquiry->validity_until ? \Carbon\Carbon::parse($inquiry->validity_until)->format('d/m/Y') : '-' }}</li>
            <li>Garansi: sesuai ketentuan POLJAM TECH</li>
            <li>Syarat pembayaran: sesuai kesepakatan</li>
        </ul>
        @if(!empty($inquiry->admin_final_notes))
        <p class="small">Catatan: {{ $inquiry->admin_final_notes }}</p>
        @endif
        <p class="muted small">Catatan: Rincian biaya internal dapat ditampilkan sebagai referensi. Nilai di atas bersifat ringkas dan tidak mencantumkan detail per item.</p>
    </div>
</body>
</html>


