<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Penjualan #{{ $sale->id }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }
        
        .content-container {
            max-width: 180mm;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .company-address {
            font-size: 11px;
            color: #666;
            margin-bottom: 3px;
        }
        
        .invoice-title {
            font-size: 20px;
            font-weight: bold;
            margin: 15px 0 10px 0;
            color: #27ae60;
        }
        
        .invoice-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        
        .invoice-info-left, .invoice-info-right {
            width: 48%;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 5px;
        }
        
        .info-label {
            font-weight: bold;
            width: 120px;
        }
        
        .info-value {
            flex: 1;
        }
        
        .product-section {
            margin: 20px 0;
        }
        
        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        
        .product-table th,
        .product-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        
        .product-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        
        .product-table .text-right {
            text-align: right;
        }
        
        .payment-breakdown {
            margin: 20px 0;
            padding: 15px;
            background-color: #f8f9fa;
            border: 2px solid #27ae60;
            border-radius: 5px;
        }
        
        .payment-title {
            font-size: 16px;
            font-weight: bold;
            color: #27ae60;
            margin-bottom: 10px;
            text-align: center;
        }
        
        .payment-details {
            display: flex;
            justify-content: space-between;
        }
        
        .payment-left, .payment-right {
            width: 48%;
        }
        
        .amount-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .amount-label {
            font-weight: bold;
        }
        
        .amount-value {
            text-align: right;
            font-weight: bold;
        }
        
        .total-amount {
            border-top: 2px solid #27ae60;
            padding-top: 10px;
            font-size: 14px;
            font-weight: bold;
            color: #27ae60;
        }
        
        .status-completed {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            padding: 10px;
            margin-top: 10px;
            border-radius: 3px;
            text-align: center;
            color: #155724;
            font-weight: bold;
        }
        
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            padding: 5px 0;
        }
        
        .total-label {
            font-weight: bold;
            width: 150px;
        }
        
        .total-value {
            width: 100px;
            text-align: right;
        }
        
        .grand-total {
            border-top: 2px solid #000;
            padding-top: 10px;
            font-size: 16px;
            font-weight: bold;
        }
        
        .terms {
            margin-top: 30px;
            font-size: 10px;
            color: #666;
        }
        
        .signature-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            height: 40px;
            margin-bottom: 5px;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
        
        
        @media print {
            body {
                margin: 0;
                padding: 10mm;
                font-size: 11px;
            }
            
            .content-container {
                max-width: 100%;
                margin: 0 auto;
                background: #fff;
                padding: 0;
                position: static;
                left: auto;
                transform: none;
            }
            
            body {
                background: #fff;
                padding: 10mm;
            }
            
            .header {
                margin-bottom: 15px;
                padding-bottom: 10px;
            }
            
            .company-name {
                font-size: 20px;
            }
            
            .company-address {
                font-size: 10px;
            }
            
            .invoice-title {
                font-size: 16px;
                margin: 10px 0 8px 0;
            }
            
            .invoice-info {
                margin-bottom: 15px;
            }
            
            .info-row {
                margin-bottom: 3px;
            }
            
            .product-table {
                font-size: 10px;
            }
            
            .product-table th,
            .product-table td {
                padding: 6px;
            }
            
            .payment-breakdown {
                margin: 15px 0;
                padding: 10px;
            }
            
            .payment-title {
                font-size: 14px;
            }
            
            .total-section {
                margin-top: 15px;
            }
            
            .terms {
                margin-top: 20px;
                font-size: 9px;
            }
            
            .signature-section {
                margin-top: 30px;
            }
            
            .footer {
                margin-top: 20px;
                font-size: 9px;
            }
            
            .no-print, .print-actions {
                display: none !important;
            }
            
            /* Memastikan alignment konsisten saat print */
            .invoice-info-left, .invoice-info-right {
                width: 48%;
            }
            
            .info-label {
                width: 120px;
                font-weight: bold;
            }
            
            .info-value {
                flex: 1;
            }
            
            /* Memastikan tabel rapi */
            .product-table {
                width: 100%;
                border-collapse: collapse;
            }
            
            .product-table th {
                background-color: #f5f5f5;
                font-weight: bold;
                text-align: left;
            }
            
            .product-table .text-right {
                text-align: right;
            }
            
            /* Memastikan payment breakdown rapi */
            .payment-details {
                display: flex;
                justify-content: space-between;
            }
            
            .payment-left, .payment-right {
                width: 48%;
            }
            
            .amount-row {
                display: flex;
                justify-content: space-between;
                margin-bottom: 5px;
            }
            
            .amount-label {
                font-weight: bold;
            }
            
            .amount-value {
                text-align: right;
                font-weight: bold;
            }
            
            /* Memastikan total section rapi */
            .total-row {
                display: flex;
                justify-content: space-between;
                margin-bottom: 3px;
            }
            
            .total-label {
                font-weight: bold;
                width: 150px;
            }
            
            .total-value {
                width: 100px;
                text-align: right;
            }
        }
    </style>
</head>
<body>
    <!-- Tombol Aksi -->
    <div class="fixed top-5 right-5 z-50 flex gap-3 print:hidden">
        <button onclick="window.print()" class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-medium text-sm rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5">
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                <path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"/>
            </svg>
            Print
        </button>
        <a href="{{ route('admin.print.sale.invoice.download', $sale) }}" class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white font-medium text-sm rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5">
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                <path d="M12,11L15,14H13V18H11V14H9L12,11Z"/>
            </svg>
            Download PDF
        </a>
    </div>
    
    <div class="content-container">
        <!-- Header Perusahaan -->
        <div class="header">
            <div class="company-name">POLJAM TECHNO WORKSHOP</div>
            <div class="company-address">Jl. Workshop No. 123, Jakarta</div>
            <div class="company-address">Telp: (021) 123-4567 | Email: info@poljamtechno.com</div>
        </div>
        
        <!-- Judul Invoice -->
        <div class="invoice-title">INVOICE PENJUALAN</div>
        
        <!-- Informasi Invoice -->
        <div class="invoice-info">
            <div class="invoice-info-left">
                <div class="info-row">
                    <div class="info-label">No. Invoice:</div>
                    <div class="info-value">#INV-{{ $sale->id }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Tanggal:</div>
                    <div class="info-value">{{ $sale->sale_date ? $sale->sale_date->format('d M Y') : $sale->created_at->format('d M Y') }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Customer:</div>
                    <div class="info-value">{{ $sale->order->customer_name ?? 'N/A' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Email:</div>
                    <div class="info-value">{{ $sale->order->customer_email ?? 'N/A' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Telepon:</div>
                    <div class="info-value">{{ $sale->order->phone_number ?? 'N/A' }}</div>
                </div>
            </div>
            <div class="invoice-info-right">
                <div class="info-row">
                    <div class="info-label">Order ID:</div>
                    <div class="info-value">#{{ $sale->order->id ?? 'N/A' }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Status:</div>
                    <div class="info-value">{{ ucfirst($sale->status) }}</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Metode Bayar:</div>
                    <div class="info-value">{{ ucfirst($sale->payment_method ?? 'N/A') }}</div>
                </div>
            </div>
        </div>
        
    <!-- Alamat Customer -->
    <div class="info-row">
        <div class="info-label">Alamat:</div>
        <div class="info-value">{{ $sale->order->address ?? 'N/A' }}</div>
    </div>
    
    <!-- Detail Produk -->
    <div class="product-section">
        <table class="product-table">
            <thead>
                <tr>
                    <th>Produk</th>
                    <th>Qty</th>
                    <th class="text-right">Harga Satuan</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $sale->product->product_title ?? 'N/A' }}</td>
                    <td>{{ $sale->quantity }}</td>
                    <td class="text-right">Rp {{ number_format($sale->unit_price, 0, ',', '.') }}</td>
                    <td class="text-right">Rp {{ number_format($sale->total_price, 0, ',', '.') }}</td>
                </tr>
            </tbody>
        </table>
    </div>
    
    <!-- Rincian Pembayaran -->
    <div class="payment-breakdown">
        <div class="payment-title">RINCIAN PEMBAYARAN</div>
        <div class="payment-details">
            <div class="payment-left">
                <div class="amount-row">
                    <div class="amount-label">Total Harga:</div>
                    <div class="amount-value">Rp {{ number_format($sale->total_price, 0, ',', '.') }}</div>
                </div>
                <div class="amount-row">
                    <div class="amount-label">Status:</div>
                    <div class="amount-value">{{ ucfirst($sale->status) }}</div>
                </div>
            </div>
            <div class="payment-right">
                <div class="amount-row">
                    <div class="amount-label">Metode Bayar:</div>
                    <div class="amount-value">{{ ucfirst($sale->payment_method ?? 'N/A') }}</div>
                </div>
                <div class="amount-row">
                    <div class="amount-label">Tanggal Bayar:</div>
                    <div class="amount-value">{{ $sale->sale_date ? $sale->sale_date->format('d M Y') : '-' }}</div>
                </div>
            </div>
        </div>
        
        <div class="status-completed">
            ✅ PEMBAYARAN LUNAS - MESIN SIAP DIKIRIM
        </div>
    </div>
    
    <!-- Total -->
    <div class="total-section">
        <div class="total-row">
            <div class="total-label">Subtotal:</div>
            <div class="total-value">Rp {{ number_format($sale->total_price, 0, ',', '.') }}</div>
        </div>
        <div class="total-row grand-total">
            <div class="total-label">TOTAL LUNAS:</div>
            <div class="total-value">Rp {{ number_format($sale->total_price, 0, ',', '.') }}</div>
        </div>
    </div>
    
    <!-- Syarat & Ketentuan -->
    <div class="terms">
        <strong>Syarat & Ketentuan:</strong><br>
        1. Invoice ini sebagai bukti pembayaran yang sah<br>
        2. Mesin telah selesai diproduksi dan siap dikirim<br>
        3. Garansi 1 tahun untuk mesin yang diproduksi<br>
        4. Service dan maintenance tersedia di workshop kami<br>
        5. Invoice ini berlaku sebagai dokumen resmi penjualan
    </div>
    
    <!-- Tanda Tangan -->
    <div class="signature-section">
        <div class="signature-box">
            <div>Customer</div>
            <div class="signature-line"></div>
            <div>({{ $sale->order->customer_name ?? 'N/A' }})</div>
        </div>
        <div class="signature-box">
            <div>Admin Workshop</div>
            <div class="signature-line"></div>
            <div>(________________)</div>
        </div>
    </div>
    
        <!-- Footer -->
        <div class="footer">
            Terima kasih atas kepercayaan Anda kepada POLJAM TECHNO WORKSHOP<br>
            Invoice ini dicetak pada {{ now()->format('d M Y H:i') }}
        </div>
    </div>
</body>
</html>
