@extends('layouts.admin')

@section('title', 'Detail Project')

@section('content')
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Project</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Informasi lengkap proyek
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="{{ route('admin.projects.edit', $project) }}"
                        class="px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-edit mr-2"></i>Edit
                    </a>
                    <a href="{{ route('admin.projects.index') }}"
                        class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-arrow-left mr-2"></i>Kembali
                    </a>
                </div>
            </div>
        </div>

        <!-- Detail Card -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Kode Bantu</label>
                    <p class="text-lg font-semibold text-gray-800 dark:text-white">{{ $project->kode_bantu }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Nama Proyek</label>
                    <p class="text-lg font-semibold text-gray-800 dark:text-white">{{ $project->nama_proyek }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Tabel Bantuan</label>
                    <p class="text-gray-800 dark:text-white">{{ $project->tabel_bantuan ?? '-' }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Nilai Kontrak</label>
                    <p class="text-gray-800 dark:text-white">{{ $project->nilai_kontrak > 0 ? 'Rp ' . number_format($project->nilai_kontrak, 0, ',', '.') : '-' }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Tanggal Mulai</label>
                    <p class="text-gray-800 dark:text-white">{{ $project->tanggal_mulai ? $project->tanggal_mulai->format('d M Y') : '-' }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Tanggal Selesai</label>
                    <p class="text-gray-800 dark:text-white">{{ $project->tanggal_selesai ? $project->tanggal_selesai->format('d M Y') : '-' }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Status</label>
                    <span class="inline-block px-3 py-1 text-sm font-medium rounded
                        {{ $project->status == 'aktif' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 
                           ($project->status == 'selesai' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200') }}">
                        {{ ucfirst($project->status) }}
                    </span>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Status Aktif</label>
                    <span class="inline-block px-3 py-1 text-sm font-medium rounded {{ $project->is_active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                        {{ $project->is_active ? 'Aktif' : 'Nonaktif' }}
                    </span>
                </div>
                @if($project->keterangan)
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Keterangan</label>
                    <p class="text-gray-800 dark:text-white">{{ $project->keterangan }}</p>
                </div>
                @endif
            </div>
        </div>

        <!-- Journal Entries -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">
                Jurnal yang Menggunakan Proyek Ini ({{ $project->journal_entries_count ?? 0 }})
            </h3>
            @if($project->journal_entries_count > 0)
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    Proyek ini digunakan dalam {{ $project->journal_entries_count }} entri jurnal.
                    <a href="{{ route('admin.reports.financial') }}?search={{ $project->kode_bantu }}" class="text-blue-600 hover:underline dark:text-blue-400">
                        Lihat di Jurnal Umum
                    </a>
                </p>
            @else
                <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada jurnal yang menggunakan proyek ini.</p>
            @endif
        </div>
    </div>
@endsection

