@extends('layouts.admin')

@section('title', 'Detail Piutang')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.master.orders.index') }}"
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Piutang</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $receivable->receivable_number }}
                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <!-- Dropdown Cetak Kwitansi -->
            <div class="relative group" x-data="{ open: false }">
                <button @click="open = !open" class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                    title="Cetak Kwitansi">
                    <i class="fas fa-print text-base"></i>
                </button>
                <div x-show="open" @click.away="open = false" x-transition
                    class="absolute right-0 mt-2 w-56 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-lg z-50">
                    <div class="py-2">
                        <a href="{{ route('admin.print.receivable.receipt', $receivable) }}" target="_blank"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <i class="fas fa-eye mr-3 text-red-600 dark:text-red-400"></i>
                            <div>
                                <div class="font-medium">Lihat & Print</div>
                                <div class="text-xs text-gray-500">Preview kwitansi DP</div>
                            </div>
                        </a>
                        <a href="{{ route('admin.print.receivable.receipt.download', $receivable) }}"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <i class="fas fa-download mr-3 text-green-600 dark:text-green-400"></i>
                            <div>
                                <div class="font-medium">Download PDF</div>
                                <div class="text-xs text-gray-500">Simpan kwitansi PDF</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
            @if($receivable->payment_status != 'paid')
                <a href="{{ route('admin.receivables.create-payment', $receivable) }}" 
                   class="inline-flex items-center justify-center w-9 h-9 text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 hover:bg-green-50 dark:hover:bg-green-900/20 rounded transition-colors duration-200"
                   title="Tambah Pembayaran">
                    <i class="fas fa-plus text-base"></i>
                </a>
            @endif
        </div>
    </div>

    <!-- Success/Error Messages -->
    @if (session('success'))
        <div class="mb-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        </div>
    @endif

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-4">
        <!-- Informasi Piutang -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-info-circle text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Piutang</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">No. Piutang:</span>
                    <span class="text-xs font-semibold text-gray-900 dark:text-gray-100">{{ $receivable->receivable_number }}</span>
                </div>
                @if($receivable->order)
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">No. Order:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100">#{{ $receivable->order->id }}</span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Customer:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->order->customer_name ?? '-' }}</span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Email:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->order->customer_email ?? '-' }}</span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Telepon:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->order->phone_number ?? '-' }}</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- Status Pembayaran -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-credit-card text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status Pembayaran</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total:</span>
                    <span class="text-xs font-semibold text-blue-600 dark:text-blue-400">Rp {{ number_format($receivable->total_amount, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Dibayar:</span>
                    <span class="text-xs font-semibold text-green-600 dark:text-green-400">Rp {{ number_format($receivable->paid_amount, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Sisa:</span>
                    <span class="text-xs font-semibold text-red-600 dark:text-red-400">Rp {{ number_format($receivable->remaining_amount, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Status:</span>
                    <div>
                        @if($receivable->payment_status == 'pending')
                            <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                {{ $receivable->payment_status_label ?? 'Belum Bayar' }}
                            </span>
                        @elseif($receivable->payment_status == 'partial')
                            <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                {{ $receivable->payment_status_label ?? 'Bayar Sebagian' }}
                            </span>
                        @elseif($receivable->payment_status == 'paid')
                            <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                {{ $receivable->payment_status_label ?? 'Lunas' }}
                            </span>
                        @elseif($receivable->payment_status == 'overdue')
                            <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                {{ $receivable->payment_status_label ?? 'Jatuh Tempo' }}
                            </span>
                        @endif
                    </div>
                </div>
                @if($receivable->due_date)
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Jatuh Tempo:</span>
                        <div>
                            <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->due_date->format('d/m/Y') }}</span>
                            @if($receivable->isOverdue())
                                <span class="ml-2 inline-flex items-center px-1.5 py-0.5 rounded text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                    Terlambat
                                </span>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Informasi Order -->
        @if($receivable->order)
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                    <i class="fas fa-shopping-cart text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Order</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Produk:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->order->product->product_title ?? '-' }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Quantity:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $receivable->order->quantity ?? '-' }} unit</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Harga:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">Rp {{ number_format($receivable->order->price ?? 0, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total:</span>
                    <span class="text-xs font-semibold text-gray-900 dark:text-gray-100">Rp {{ number_format($receivable->total_amount, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Metode:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ ucfirst($receivable->order->payment_method ?? '-') }}</span>
                </div>
            </div>
        </div>
        @endif
    </div>

    <!-- Catatan -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4 transition-colors duration-300">
        <div class="flex items-center justify-between mb-3">
            <div class="flex items-center">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                    <i class="fas fa-sticky-note text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Catatan</h3>
            </div>
            <button class="inline-flex items-center px-2.5 py-1 text-xs font-medium text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/30 transition duration-200" 
                    onclick="editNotes()">
                <i class="fas fa-edit mr-1 text-xs"></i>
                Edit
            </button>
        </div>
        <div id="notes-display">
            @if($receivable->notes)
                <p class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed">{{ $receivable->notes }}</p>
            @else
                <p class="text-sm text-gray-500 dark:text-gray-400 italic">Tidak ada catatan</p>
            @endif
        </div>
        
        <div id="notes-edit" style="display: none;">
            <form method="POST" action="{{ route('admin.receivables.update-notes', $receivable) }}">
                @csrf
                @method('PUT')
                <div class="mb-3">
                    <textarea class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 transition-colors duration-200 bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm resize-none" 
                              name="notes" 
                              rows="3" 
                              placeholder="Masukkan catatan...">{{ $receivable->notes }}</textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" class="px-4 py-2 text-xs font-medium text-gray-600 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-200 dark:hover:bg-gray-600 transition duration-200" 
                            onclick="cancelEditNotes()">
                        <i class="fas fa-times mr-1"></i>
                        Batal
                    </button>
                    <button type="submit" class="px-4 py-2 text-xs font-medium text-white bg-yellow-600 hover:bg-yellow-700 rounded-lg transition duration-200">
                        <i class="fas fa-save mr-1"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Aksi Cepat -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-3">
            <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg mr-2">
                <i class="fas fa-bolt text-orange-600 dark:text-orange-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Aksi Cepat</h3>
        </div>
        <div class="flex flex-wrap gap-2">
            @if($receivable->payment_status != 'paid')
                <a href="{{ route('admin.receivables.create-payment', $receivable) }}" 
                   class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-plus mr-2 text-xs"></i>
                    Tambah Pembayaran
                </a>
            @endif
            
            @if($receivable->due_date)
                <button class="inline-flex items-center px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm" 
                        onclick="editDueDate()">
                    <i class="fas fa-calendar mr-2 text-xs"></i>
                    Edit Jatuh Tempo
                </button>
            @endif
            
            @if($receivable->payment_status != 'paid' && $receivable->status != 'cancelled')
                <form method="POST" action="{{ route('admin.receivables.cancel', $receivable) }}" 
                      class="inline m-0 p-0" onsubmit="return confirmCancel(event)">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-ban mr-2 text-xs"></i>
                        Batalkan Piutang
                    </button>
                </form>
            @endif
        </div>
    </div>

    <!-- Modal Edit Jatuh Tempo -->
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden" id="editDueDateModal">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-lg bg-white dark:bg-gray-800">
            <div class="mt-3">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">Edit Jatuh Tempo</h3>
                    <button type="button" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300" onclick="closeModal()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.receivables.update-due-date', $receivable) }}">
                    @csrf
                    @method('PUT')
                    <div class="mb-4">
                        <label for="due_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Jatuh Tempo</label>
                        <input type="date" class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 transition-colors duration-200 bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm" 
                               id="due_date" name="due_date" 
                               value="{{ $receivable->due_date ? $receivable->due_date->format('Y-m-d') : '' }}" 
                               min="{{ date('Y-m-d', strtotime('+1 day')) }}" required>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" class="px-4 py-2 text-sm bg-gray-500 hover:bg-gray-600 text-white font-medium rounded-lg transition duration-200" 
                                onclick="closeModal()">
                            Batal
                        </button>
                        <button type="submit" class="px-4 py-2 text-sm bg-yellow-600 hover:bg-yellow-700 text-white font-medium rounded-lg transition duration-200">
                            Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function editNotes() {
            document.getElementById('notes-display').style.display = 'none';
            document.getElementById('notes-edit').style.display = 'block';
        }
        
        function cancelEditNotes() {
            document.getElementById('notes-display').style.display = 'block';
            document.getElementById('notes-edit').style.display = 'none';
        }
        
        function editDueDate() {
            document.getElementById('editDueDateModal').classList.remove('hidden');
        }
        
        function closeModal() {
            document.getElementById('editDueDateModal').classList.add('hidden');
        }
        
        function confirmCancel(event) {
            event.preventDefault();
            Swal.fire({
                title: 'Yakin ingin membatalkan?',
                text: 'Piutang ini akan dibatalkan!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#e3342f',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, batalkan!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    event.target.closest('form').submit();
                }
            });
            return false;
        }
        
        // Close modal when clicking outside
        document.getElementById('editDueDateModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });
    </script>
@endsection
