@extends('layouts.admin')

@section('title', 'Laporan Perubahan Modal')

@section('content')
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Perubahan Modal</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Laporan perubahan ekuitas pemegang saham untuk periode tertentu
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="{{ route('admin.reports.equity-changes.export', request()->all()) }}" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </a>
                </div>
            </div>
        </div>

        <!-- Filter Form -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <form method="GET" action="{{ route('admin.reports.equity-changes') }}" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Awal</label>
                    <input type="date" name="start_date" value="{{ $startDate ?? date('Y-01-01') }}" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Akhir</label>
                    <input type="date" name="end_date" value="{{ $endDate ?? date('Y-m-d') }}" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Report Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
            <!-- Header Info -->
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="text-center mb-4">
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">POLJAMTECH</h2>
                    <p class="text-sm text-gray-600 dark:text-gray-400">Jl. Lkr. Barat 3 No.1, Bagan Pete, Kec. Kota Baru, Kota Jambi, Jambi 36361</p>
                </div>
                <div class="text-center">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white">LAPORAN PERUBAHAN MODAL</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                        Per {{ isset($endDate) ? \Carbon\Carbon::parse($endDate)->format('d-M-y') : date('d-M-y') }}
                    </p>
                </div>
            </div>

            <div class="p-6">
                <div class="overflow-x-auto">
                    <table class="w-full border border-gray-300 dark:border-gray-600">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" style="width: 60%;">Keterangan</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold uppercase border-b border-gray-300 dark:border-gray-600" style="width: 40%;">Jumlah</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Ekuitas Awal -->
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600">
                                    Ekuitas Awal Pemegang Saham periode
                                </td>
                                <td class="px-4 py-3 text-right text-sm border-gray-300 dark:border-gray-600">
                                    {{ abs($beginningEquity ?? 0) > 0.01 ? number_format($beginningEquity, 0, ',', '.') : '-' }}
                                </td>
                            </tr>
                            
                            <!-- Penambahan Ekuitas -->
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm font-semibold border-r border-gray-300 dark:border-gray-600">
                                    Penambahan Ekuitas Pemegang Saham :
                                </td>
                                <td class="px-4 py-3 text-sm border-gray-300 dark:border-gray-600"></td>
                            </tr>
                            
                            <!-- Modal (310-01) -->
                            @php
                                $modalAccount = $equityAccounts->firstWhere('kd_perk', '310-01');
                            @endphp
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600 pl-8">
                                    310-01 MODAL
                                </td>
                                <td class="px-4 py-3 text-right text-sm border-gray-300 dark:border-gray-600">
                                    {{ $modalAccount && abs($modalAccount['change']) > 0.01 ? number_format($modalAccount['change'], 0, ',', '.') : '-' }}
                                </td>
                            </tr>
                            
                            <!-- Deviden (310-03) -->
                            @php
                                $devidenAccount = $equityAccounts->firstWhere('kd_perk', '310-03');
                            @endphp
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600 pl-8">
                                    310-03 DEVIDEN
                                </td>
                                <td class="px-4 py-3 text-right text-sm border-gray-300 dark:border-gray-600">
                                    {{ $devidenAccount && abs($devidenAccount['change']) > 0.01 ? number_format($devidenAccount['change'], 0, ',', '.') : '-' }}
                                </td>
                            </tr>
                            
                            <!-- Laba (Rugi) Tahun Berjalan (310-04) -->
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600 pl-8">
                                    310-04 LABA (RUGI) TAHUN BERJALAN
                                </td>
                                <td class="px-4 py-3 text-right text-sm border-gray-300 dark:border-gray-600">
                                    {{ abs($currentYearProfitLoss) > 0.01 ? number_format($currentYearProfitLoss, 0, ',', '.') : '-' }}
                                </td>
                            </tr>
                            
                            <!-- Total Penambahan Ekuitas -->
                            <tr class="bg-gray-50 dark:bg-gray-700 border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm font-semibold border-r border-gray-300 dark:border-gray-600">
                                    Total Penambahan Ekuitas Pemegang Saham
                                </td>
                                <td class="px-4 py-3 text-right text-sm font-semibold border-gray-300 dark:border-gray-600">
                                    {{ number_format($totalAdditions, 0, ',', '.') }}
                                </td>
                            </tr>
                            
                            <!-- Ekuitas Akhir -->
                            <tr class="bg-blue-50 dark:bg-blue-900/20 border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-sm font-bold border-r border-gray-300 dark:border-gray-600">
                                    Ekuitas Pemegang Saham Akhir Periode
                                </td>
                                <td class="px-4 py-3 text-right text-sm font-bold border-gray-300 dark:border-gray-600">
                                    {{ number_format($endingEquity, 0, ',', '.') }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

