<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAPORAN PENJUALAN - {{ date('d M Y') }}</title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: white;
            color: #1f2937;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #1f2937;
            padding-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 10px;
        }
        
        .report-title {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .report-period {
            font-size: 12px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .info-section {
            margin-bottom: 25px;
            background: #f8fafc;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #3b82f6;
        }
        
        .info-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            width: 30%;
            font-weight: bold;
            color: #374151;
            padding: 5px 0;
        }
        
        .info-value {
            display: table-cell;
            color: #1f2937;
            padding: 5px 0;
        }
        
        .summary-section {
            margin-bottom: 25px;
        }
        
        .summary-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .summary-row {
            display: table-row;
        }
        
        .summary-cell {
            display: table-cell;
            width: 25%;
            padding: 10px;
            text-align: center;
            border: 1px solid #d1d5db;
            background: #f9fafb;
        }
        
        .summary-cell.primary {
            background: #dbeafe;
            font-weight: bold;
        }
        
        .summary-label {
            font-size: 10px;
            color: #6b7280;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
        }
        
        .data-section {
            margin-bottom: 25px;
        }
        
        .data-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }
        
        th {
            background: #374151;
            color: white;
            font-weight: bold;
            font-size: 10px;
            text-transform: uppercase;
            padding: 8px 6px;
            text-align: left;
            border: 1px solid #1f2937;
        }
        
        td {
            padding: 6px;
            border: 1px solid #d1d5db;
            font-size: 10px;
            vertical-align: top;
        }
        
        tr:nth-child(even) {
            background: #f9fafb;
        }
        
        tr:nth-child(odd) {
            background: white;
        }
        
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-success {
            background: #dcfce7;
            color: #166534;
        }
        
        .status-danger {
            background: #fef2f2;
            color: #991b1b;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .footer {
            margin-top: 30px;
            border-top: 2px solid #e5e7eb;
            padding-top: 15px;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            width: 50%;
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-right {
            display: table-cell;
            width: 50%;
            text-align: right;
            font-size: 10px;
            color: #6b7280;
        }
        
        .signature-section {
            margin-top: 40px;
            display: table;
            width: 100%;
        }
        
        .signature-left {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-right {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-line {
            border-bottom: 1px solid #374151;
            width: 200px;
            margin: 0 auto 5px auto;
            height: 40px;
        }
        
        .signature-label {
            font-size: 10px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .no-data {
            text-align: center;
            padding: 30px;
            color: #6b7280;
            font-style: italic;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="company-name">PT. POLJAM TECH</div>
        <div class="company-address">
            Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi
        </div>
        <div class="report-title">Laporan Penjualan</div>
        <div class="report-period">
            Periode: {{ request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Semua' }} 
            {{ request('end_date') ? ' - ' . \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : '' }}
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Tanggal Laporan:</div>
                <div class="info-value">{{ now()->format('d M Y H:i') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Status Filter:</div>
                <div class="info-value">{{ request('status') ? ucfirst(request('status')) : 'Semua Status' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Total Data:</div>
                <div class="info-value">{{ $sales->count() }} transaksi</div>
            </div>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="summary-title">Ringkasan Penjualan</div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell primary">
                    <div class="summary-label">Total Penjualan</div>
                    <div class="summary-value">Rp {{ number_format($totalSales, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Total Quantity</div>
                    <div class="summary-value">{{ number_format($totalQuantity, 0, ',', '.') }} unit</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Total Transaksi</div>
                    <div class="summary-value">{{ number_format($totalTransactions, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Rata-rata per Transaksi</div>
                    <div class="summary-value">Rp {{ $totalTransactions > 0 ? number_format($totalSales / $totalTransactions, 0, ',', '.') : '0' }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Section -->
    <div class="data-section">
        <div class="data-title">Detail Transaksi Penjualan</div>
        
        @if($sales->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 8%;">No</th>
                    <th style="width: 12%;">Tanggal</th>
                    <th style="width: 10%;">Kode Order</th>
                    <th style="width: 20%;">Nama Produk</th>
                    <th style="width: 15%;">Customer</th>
                    <th style="width: 8%;">Qty</th>
                    <th style="width: 10%;">Harga Satuan</th>
                    <th style="width: 12%;">Total Harga</th>
                    <th style="width: 8%;">Status</th>
                    <th style="width: 7%;">Pembayaran</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sales as $index => $sale)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $sale->sale_date->format('d/m/Y') }}</td>
                    <td class="text-center">{{ $sale->order->id ?? '-' }}</td>
                    <td>{{ $sale->product->product_title ?? '-' }}</td>
                    <td>{{ $sale->user->name ?? $sale->order->customer_name ?? '-' }}</td>
                    <td class="text-center">{{ number_format($sale->quantity, 0, ',', '.') }}</td>
                    <td class="text-right">Rp {{ number_format($sale->unit_price, 0, ',', '.') }}</td>
                    <td class="text-right font-bold">Rp {{ number_format($sale->total_price, 0, ',', '.') }}</td>
                    <td class="text-center">
                        <span class="status-badge {{ $sale->status == 'selesai' ? 'status-success' : 'status-danger' }}">
                            {{ $sale->status == 'selesai' ? 'Selesai' : 'Batal' }}
                        </span>
                    </td>
                    <td class="text-center">{{ $sale->payment_method ?? '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div class="no-data">
            <p>Tidak ada data penjualan untuk periode yang dipilih.</p>
        </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-left">
            <p><strong>PT. POLJAM TECH</strong></p>
            <p>Laporan ini dibuat secara otomatis oleh sistem</p>
        </div>
        <div class="footer-right">
            <p>Halaman 1 dari 1</p>
            <p>Dicetak pada: {{ now()->format('d M Y H:i') }}</p>
        </div>
    </div>

    <!-- Signature Section -->
    <div class="signature-section">
        <div class="signature-left">
            <div class="signature-line"></div>
            <div class="signature-label">Mengetahui,<br>Manager Penjualan</div>
        </div>
        <div class="signature-right">
            <div class="signature-line"></div>
            <div class="signature-label">Jakarta, {{ now()->format('d M Y') }}<br>Direktur</div>
        </div>
    </div>
</body>
</html>