@extends('layouts.admin')

@section('title', 'Laporan Laba Rugi Per Bulan')

@section('content')
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Laba Rugi Per Bulan</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Laporan laba rugi berdasarkan bulan
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="{{ route('admin.reports.profit-loss-month.export', request()->all()) }}" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </a>
                </div>
            </div>
        </div>

        <!-- Filter Form -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <form method="GET" action="{{ route('admin.reports.profit-loss-month') }}" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Bulan</label>
                    <input type="month" name="month" value="{{ request('month', date('Y-m')) }}" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Report Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-white text-center">LAPORAN LABA RUGI</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1 text-center">{{ $monthName ?? '' }}</p>
            </div>

            <div class="p-6">
                <div class="overflow-x-auto">
                    <table class="w-full border border-gray-300 dark:border-gray-600">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">Keterangan</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold uppercase border-b border-gray-300 dark:border-gray-600">Jumlah</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Pendapatan -->
                            <tr class="bg-blue-50 dark:bg-blue-900/20">
                                <td class="px-4 py-3 font-semibold border-r border-gray-300 dark:border-gray-600">Pendapatan :</td>
                                <td class="px-4 py-3"></td>
                            </tr>
                            @forelse($revenueAccounts ?? [] as $account)
                                @if($account['amount'] > 0)
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8">{{ strtoupper($account['nama_perkiraan']) }}</td>
                                        <td class="px-4 py-2 text-right">{{ number_format($account['amount'], 0, ',', '.') }}</td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic">Tidak ada data pendapatan</td>
                                    <td class="px-4 py-2 text-right">-</td>
                                </tr>
                            @endforelse
                            <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PENDAPATAN</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($revenue, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Harga Pokok Penjualan -->
                            <tr class="bg-red-50 dark:bg-red-900/20">
                                <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600">HARGA POKOK PENJUALAN</td>
                                <td class="px-4 py-3 border-t border-gray-300 dark:border-gray-600"></td>
                            </tr>
                            @forelse($cogsAccounts ?? [] as $account)
                                @if($account['amount'] > 0)
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8">{{ strtoupper($account['nama_perkiraan']) }}</td>
                                        <td class="px-4 py-2 text-right">{{ number_format($account['amount'], 0, ',', '.') }}</td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic">Tidak ada data HPP</td>
                                    <td class="px-4 py-2 text-right">-</td>
                                </tr>
                            @endforelse
                            <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH HARGA POKOK</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($cogs, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Laba Bruto -->
                            <tr class="bg-green-50 dark:bg-green-900/20 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA BRUTO</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($grossProfit, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Beban Administrasi & Umum -->
                            <tr class="bg-yellow-50 dark:bg-yellow-900/20">
                                <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600">BEBAN ADMINISTRASI & UMUM</td>
                                <td class="px-4 py-3 border-t border-gray-300 dark:border-gray-600"></td>
                            </tr>
                            @forelse($expenseAccounts ?? [] as $account)
                                @if($account['amount'] > 0)
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8">{{ strtoupper($account['nama_perkiraan']) }}</td>
                                        <td class="px-4 py-2 text-right">{{ number_format($account['amount'], 0, ',', '.') }}</td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic">Tidak ada data beban administrasi</td>
                                    <td class="px-4 py-2 text-right">-</td>
                                </tr>
                            @endforelse
                            <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">Jumlah Beban Administrasi Dan Umum</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($operatingExpenses, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Laba (Rugi) Usaha -->
                            <tr class="bg-purple-50 dark:bg-purple-900/20 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA (RUGI) Usaha</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($operatingProfit, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Pendapatan (Beban) Lain-Lain -->
                            <tr class="bg-indigo-50 dark:bg-indigo-900/20">
                                <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600">PENDAPATAN (BEBAN) LAIN - LAIN</td>
                                <td class="px-4 py-3 border-t border-gray-300 dark:border-gray-600"></td>
                            </tr>
                            @forelse($otherIncomeAccounts ?? [] as $account)
                                @if($account['amount'] != 0)
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8">{{ strtoupper($account['nama_perkiraan']) }}</td>
                                        <td class="px-4 py-2 text-right {{ $account['amount'] < 0 ? 'text-red-600' : '' }}">
                                            {{ $account['amount'] != 0 ? number_format($account['amount'], 0, ',', '.') : '-' }}
                                        </td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic">Tidak ada data pendapatan/beban lain</td>
                                    <td class="px-4 py-2 text-right">-</td>
                                </tr>
                            @endforelse
                            <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PENDAPATAN (BEBAN) LAIN - LAIN</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600 {{ $otherIncome < 0 ? 'text-red-600' : '' }}">
                                    {{ $otherIncome != 0 ? number_format($otherIncome, 0, ',', '.') : '-' }}
                                </td>
                            </tr>

                            <!-- Laba (Rugi) -->
                            <tr class="bg-orange-50 dark:bg-orange-900/20 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA (RUGI)</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($profitBeforeTax, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Pajak Penghasilan -->
                            <tr class="bg-pink-50 dark:bg-pink-900/20">
                                <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600">PAJAK PENGHASILAN</td>
                                <td class="px-4 py-3 border-t border-gray-300 dark:border-gray-600"></td>
                            </tr>
                            @forelse($taxAccounts ?? [] as $account)
                                @if($account['amount'] > 0)
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8">{{ strtoupper($account['nama_perkiraan']) }}</td>
                                        <td class="px-4 py-2 text-right">{{ number_format($account['amount'], 0, ',', '.') }}</td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic">Tidak ada data pajak</td>
                                    <td class="px-4 py-2 text-right">-</td>
                                </tr>
                            @endforelse
                            <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PPH</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ $tax > 0 ? number_format($tax, 0, ',', '.') : '-' }}</td>
                            </tr>

                            <!-- Laba Rugi Setelah Pajak -->
                            <tr class="bg-teal-50 dark:bg-teal-900/20 font-bold text-lg">
                                <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA RUGI SETELAH PAJAK</td>
                                <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600">{{ number_format($netProfit, 0, ',', '.') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

