<!-- Sparepart Purchase Form Card -->
<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 relative mb-5">
    <button type="button"
        class="absolute top-4 right-4 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200"
        onclick="removeItem(this)">
        <i class="fas fa-times text-sm"></i>
    </button>

    <!-- Header Card -->
    <div class="flex items-center mb-5">
        <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900/40 rounded-lg flex items-center justify-center mr-3">
            <i class="fas fa-cog text-blue-600 dark:text-blue-400"></i>
        </div>
        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Item Sparepart</h3>
    </div>

    <!-- Item Selection -->
    <div class="mb-5">
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
            Pilih Sparepart atau Buat Baru <span class="text-red-500">*</span>
        </label>
        <select name="items[{{ $index }}][item_id]" class="item-select w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
            <option value="">-- Pilih Sparepart atau Buat Baru --</option>
            @foreach($sparepartsForJs as $sparepart)
                <option value="{{ $sparepart['id'] }}"
                    {{ old("items.{$index}.item_id") == $sparepart['id'] ? 'selected' : '' }}
                    data-name="{{ $sparepart['name'] }}"
                    data-unit="{{ $sparepart['unit'] ?? 'pcs' }}"
                    data-code="{{ $sparepart['part_code'] ?? '' }}"
                    data-brand="{{ $sparepart['brand'] ?? '' }}"
                    data-type="{{ $sparepart['type'] ?? '' }}"
                    data-part_number="{{ $sparepart['part_number'] ?? '' }}"
                    data-price="{{ $sparepart['price'] ?? 0 }}"
                    data-description="{{ $sparepart['description'] ?? '' }}"
                    data-image="{{ $sparepart['image'] ?? '' }}">
                    {{ $sparepart['name'] }}
                </option>
            @endforeach
        </select>
    </div>

    <!-- Basic Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Part Code -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Sparepart</label>
            <input type="text" name="items[{{ $index }}][part_code]" value="{{ old("items.{$index}.part_code") }}"
                class="code-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Jika kosong, otomatis dibuat unik">
        </div>

        <!-- Nama Sparepart -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Nama Sparepart <span class="text-red-500">*</span>
            </label>
            <input type="text" name="items[{{ $index }}][item_name]" value="{{ old("items.{$index}.item_name") }}" required
                class="item-name w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm @error("items.{$index}.item_name") border-red-500 @enderror"
                placeholder="Masukkan nama sparepart">
            @error("items.{$index}.item_name")
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Brand -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Brand</label>
            <input type="text" name="items[{{ $index }}][brand]" value="{{ old("items.{$index}.brand") }}"
                class="brand-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Merk / brand">
        </div>
    </div>

    <!-- Additional Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Type -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tipe</label>
            <input type="text" name="items[{{ $index }}][type]" value="{{ old("items.{$index}.type") }}"
                class="type-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Tipe sparepart">
        </div>

        <!-- Part Number -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Part Number</label>
            <input type="text" name="items[{{ $index }}][part_number]" value="{{ old("items.{$index}.part_number") }}"
                class="part-number-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Nomor part">
        </div>

        <!-- Quantity -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Quantity <span class="text-red-500">*</span>
            </label>
            <input type="number" name="items[{{ $index }}][quantity]" min="1" step="1" value="{{ old("items.{$index}.quantity", 1) }}" required
                class="quantity w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm @error("items.{$index}.quantity") border-red-500 @enderror"
                placeholder="1">
            @error("items.{$index}.quantity")
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <!-- Purchase Details -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
        <!-- Unit -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
            <input type="text" name="items[{{ $index }}][unit]" value="{{ old("items.{$index}.unit", 'pcs') }}"
                class="unit w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="pcs">
        </div>

        <!-- Unit Price -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Harga Satuan (Rp) <span class="text-red-500">*</span>
            </label>
            <input type="number" name="items[{{ $index }}][unit_price]" min="0" step="0.01" value="{{ old("items.{$index}.unit_price") }}" required
                class="unit-price w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm @error("items.{$index}.unit_price") border-red-500 @enderror"
                placeholder="0">
            @error("items.{$index}.unit_price")
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Total Price (Read-only) -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Total Harga</label>
            <input type="text" readonly
                class="total-price w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white text-sm font-semibold"
                value="Rp 0">
        </div>

        <!-- Status -->
        <div class="flex items-center">
            <input type="checkbox" name="items[{{ $index }}][is_active]" value="1" {{ old("items.{$index}.is_active", true) ? 'checked' : '' }}
                class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
            <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
        </div>
    </div>

    <!-- Description & Image -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
        <!-- Deskripsi -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
            <textarea name="items[{{ $index }}][description]" rows="3"
                class="description-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm"
                placeholder="Tuliskan deskripsi sparepart jika perlu...">{{ old("items.{$index}.description") }}</textarea>
        </div>

        <!-- Gambar -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
            <div class="space-y-3">
                <input type="file" name="items[{{ $index }}][image]" accept="image/*" onchange="previewImage(this, 'preview-{{ $index }}')"
                    class="image-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                
                <!-- Image Preview -->
                <div class="relative w-full max-w-xs">
                    <div id="preview-container-{{ $index }}" class="hidden">
                        <div class="relative border border-gray-200 dark:border-gray-600 rounded-lg p-2 bg-gray-50 dark:bg-gray-700/50">
                            <img id="preview-{{ $index }}" src="" alt="Preview" 
                                class="w-full h-48 object-contain rounded"
                                style="background: transparent;">
                            
                            <!-- Remove Button -->
                            <button type="button" onclick="removeImage(this, 'preview-{{ $index }}')"
                                class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 shadow-lg">
                                <i class="fas fa-times text-sm"></i>
                            </button>
                        </div>
                    </div>
                    <div id="no-image-{{ $index }}" class="text-xs text-gray-500 dark:text-gray-400 italic">
                        Belum ada gambar yang dipilih
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

