<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bukti Pembelian - {{ $purchase->purchase_code }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.5;
            color: #000;
            background: #fff;
            margin: 0;
            padding: 0;
        }
        
        .page {
            width: 210mm;
            min-height: 297mm;
            margin: 0 auto;
            padding: 15mm;
            background: #fff;
            box-sizing: border-box;
        }
        
        .header {
            border-bottom: 3px solid #1e40af;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .company-info {
            text-align: center;
            margin-bottom: 15px;
        }
        
        .company-name {
            font-size: 20px;
            font-weight: bold;
            color: #1e40af;
            margin-bottom: 5px;
        }
        
        .company-address {
            font-size: 10px;
            color: #666;
            line-height: 1.4;
        }
        
        .document-title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin: 15px 0;
            color: #1e40af;
        }
        
        .document-info {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            font-weight: bold;
            width: 35%;
            padding: 5px 0;
            color: #333;
        }
        
        .info-value {
            display: table-cell;
            padding: 5px 0;
            color: #000;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 10px;
        }
        
        .items-table th {
            background-color: #1e40af;
            color: #fff;
            padding: 8px 5px;
            text-align: left;
            font-weight: bold;
            border: 1px solid #1e3a8a;
        }
        
        .items-table td {
            padding: 7px 5px;
            border: 1px solid #ddd;
            vertical-align: top;
        }
        
        .items-table tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        .items-table tbody tr:hover {
            background-color: #f3f4f6;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .total-row {
            background-color: #f0f9ff;
            font-weight: bold;
        }
        
        .total-row td {
            border-top: 2px solid #1e40af;
            padding: 10px 5px;
            font-size: 11px;
        }
        
        .notes-section {
            margin-top: 20px;
            padding: 10px;
            background-color: #fffbeb;
            border-left: 4px solid #f59e0b;
        }
        
        .notes-title {
            font-weight: bold;
            margin-bottom: 5px;
            color: #92400e;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 9px;
            color: #666;
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
        }
        
        .badge-material {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .badge-sparepart {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        @media screen {
            body {
                background: #f5f5f5;
                padding: 20px;
            }
            
            .page {
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
        }
        
        @media print {
            body {
                background: #fff;
                padding: 0;
            }
            
            .page {
                margin: 0;
                padding: 15mm;
                box-shadow: none;
            }
            
            .no-print {
                display: none;
            }
            
            @page {
                size: A4;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="page">
    <!-- Header -->
    <div class="header">
        <div class="company-info">
            <div class="company-name">POLJAM TECH</div>
            <div class="company-address">
                Jl. Contoh No. 123, Kota Contoh, Provinsi Contoh<br>
                Telp: (021) 1234-5678 | Email: info@poljamtech.com
            </div>
        </div>
        <div class="document-title">BUKTI PEMBELIAN</div>
    </div>

    <!-- Document Information -->
    <div class="document-info">
        <div class="info-row">
            <div class="info-label">Kode Pembelian:</div>
            <div class="info-value"><strong>{{ $purchase->purchase_code }}</strong></div>
        </div>
        <div class="info-row">
            <div class="info-label">Tanggal Pembelian:</div>
            <div class="info-value">{{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d F Y') }}</div>
        </div>
        <div class="info-row">
            <div class="info-label">Supplier:</div>
            <div class="info-value">{{ $purchase->supplier_name ?? 'Tidak disebutkan' }}</div>
        </div>
        <div class="info-row">
            <div class="info-label">Tipe Pembelian:</div>
            <div class="info-value">
                <span class="badge {{ $purchase->purchase_type === 'material' ? 'badge-material' : 'badge-sparepart' }}">
                    {{ $purchase->purchase_type === 'material' ? 'Material' : 'Sparepart' }}
                </span>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">No</th>
                <th style="width: 40%;">Nama Item</th>
                <th style="width: 10%;" class="text-center">Unit</th>
                <th style="width: 10%;" class="text-right">Qty</th>
                <th style="width: 17.5%;" class="text-right">Harga Satuan</th>
                <th style="width: 17.5%;" class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($purchase->items as $item)
                @php
                    $itemData = null;
                    if ($item->item_type === 'material' && $item->item_id) {
                        $itemData = \App\Models\Material::find($item->item_id);
                    } elseif ($item->item_type === 'sparepart' && $item->item_id) {
                        $itemData = \App\Models\Sparepart::find($item->item_id);
                    }
                @endphp
                <tr>
                    <td class="text-center">{{ $loop->iteration }}</td>
                    <td>
                        <strong>{{ $item->item_name }}</strong>
                        <br>
                        <span class="badge {{ $item->item_type === 'material' ? 'badge-material' : 'badge-sparepart' }}">
                            {{ ucfirst($item->item_type) }}
                        </span>
                        @if ($itemData)
                            <br>
                            <span style="color: #666; font-size: 9px;">
                                @if ($item->item_type === 'material')
                                    Kode: {{ $itemData->material_code ?? '-' }}
                                    @if($itemData->category) | Kategori: {{ $itemData->category }} @endif
                                @else
                                    Kode: {{ $itemData->part_code ?? '-' }}
                                    @if($itemData->brand) | Brand: {{ $itemData->brand }} @endif
                                @endif
                            </span>
                        @endif
                    </td>
                    <td class="text-center">{{ $item->unit ?? '-' }}</td>
                    <td class="text-right">{{ number_format($item->quantity, 0, ',', '.') }}</td>
                    <td class="text-right">Rp {{ number_format($item->unit_price, 0, ',', '.') }}</td>
                    <td class="text-right"><strong>Rp {{ number_format($item->total_price, 0, ',', '.') }}</strong></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="5" class="text-right" style="font-size: 12px;">TOTAL PEMBELIAN:</td>
                <td class="text-right" style="font-size: 13px; color: #1e40af;">Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}</td>
            </tr>
        </tfoot>
    </table>

    <!-- Notes Section -->
    @if ($purchase->notes)
        <div class="notes-section">
            <div class="notes-title">Catatan Pembelian:</div>
            <div>{{ $purchase->notes }}</div>
        </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <div style="margin-bottom: 10px;">
            <strong>Dokumen ini adalah bukti resmi pencatatan pembelian barang</strong>
        </div>
        <div>
            Dicetak pada: {{ now()->format('d F Y, H:i') }} WIB
        </div>
        <div style="margin-top: 5px;">
            Dibuat: {{ \Carbon\Carbon::parse($purchase->created_at)->format('d F Y, H:i') }} WIB | 
            Diperbarui: {{ \Carbon\Carbon::parse($purchase->updated_at)->format('d F Y, H:i') }} WIB
        </div>
    </div>
    </div>
</body>
</html>

