@extends('layouts.admin')

@section('title', 'Detail User')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-4">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.users.index') }}" 
                class="flex items-center justify-center w-9 h-9 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h1 class="text-xl font-bold text-gray-800 dark:text-white">Detail User</h1>
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                    ID: #{{ $user->id }}  {{ $user->email }}
                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            @if(!$user->isAdmin())
                <a href="{{ route('admin.users.edit', $user->id) }}"
                    class="px-3 py-1.5 bg-blue-500 hover:bg-blue-600 text-white text-sm font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-edit text-xs"></i>
                    <span>Edit</span>
                </a>
            @endif
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-3 mb-3">
        <!-- Profile Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-1.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Profil</h3>
            </div>
            
            <!-- Photo -->
            <div class="flex justify-center mb-3">
                @php
                    $hasPhoto = false;
                    $photoUrl = '';
                    if ($user->photo) {
                        $photoPath = (strpos($user->photo, 'profiles/') === 0) 
                            ? $user->photo 
                            : 'profiles/' . $user->photo;
                        
                        if (\Storage::disk('uploads')->exists($photoPath)) {
                            $hasPhoto = true;
                            $photoFileName = (strpos($user->photo, 'profiles/') === 0) 
                                ? $user->photo 
                                : 'profiles/' . $user->photo;
                            $photoUrl = asset('uploads/' . $photoFileName);
                        }
                    }
                @endphp
                @if($hasPhoto)
                    <div class="relative w-28 h-28 rounded-xl overflow-hidden shadow-lg ring-4 ring-white dark:ring-gray-800 bg-gradient-to-br from-blue-500 via-blue-400 to-cyan-400">
                        <img src="{{ $photoUrl }}" alt="Foto Profil" 
                             class="w-full h-full object-cover"
                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                        <div class="w-full h-full bg-gradient-to-br from-blue-500 via-blue-400 to-cyan-400 flex items-center justify-center" style="display: none;">
                            <span class="text-white text-3xl font-bold">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
                        </div>
                    </div>
                @else
                    <div class="w-28 h-28 rounded-xl overflow-hidden shadow-lg ring-4 ring-white dark:ring-gray-800 bg-gradient-to-br from-blue-500 via-blue-400 to-cyan-400 flex items-center justify-center">
                        <span class="text-white text-3xl font-bold">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
                    </div>
                @endif
            </div>

            <div class="space-y-2">
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Nama Lengkap</span>
                    <span class="text-sm font-semibold text-gray-900 dark:text-gray-100">{{ $user->name }}</span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Email</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100 break-all">{{ $user->email }}</span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Role</span>
                    <div class="mt-0.5">
                        @if($user->user_type === 'teknisi')
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-200">
                                <i class="fas fa-tools mr-1 text-xs"></i> Teknisi
                            </span>
                        @elseif($user->user_type === 'supervisor')
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-purple-100 dark:bg-purple-900/40 text-purple-800 dark:text-purple-200">
                                <i class="fas fa-user-shield mr-1 text-xs"></i> Supervisor
                            </span>
                        @elseif($user->user_type === 'admin')
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-200">
                                <i class="fas fa-crown mr-1 text-xs"></i> Admin
                            </span>
                        @else
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200">
                                <i class="fas fa-user mr-1 text-xs"></i> User
                            </span>
                        @endif
                    </div>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Status</span>
                    <div class="mt-0.5">
                        @if($user->is_active)
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-200">
                                <i class="fas fa-check-circle mr-1 text-xs"></i> Aktif
                            </span>
                        @else
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-200">
                                <i class="fas fa-times-circle mr-1 text-xs"></i> Nonaktif
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-1.5 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-address-card text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Kontak</h3>
            </div>
            <div class="space-y-2">
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Telepon</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        @if($user->phone)
                            {{ $user->phone }}
                        @else
                            <span class="text-gray-400 dark:text-gray-500 italic text-xs">Tidak ada</span>
                        @endif
                    </span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Alamat</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        @if($user->address)
                            {{ $user->address }}
                        @else
                            <span class="text-gray-400 dark:text-gray-500 italic text-xs">Tidak ada</span>
                        @endif
                    </span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Kode Pos</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        @if($user->postal_code)
                            {{ $user->postal_code }}
                        @else
                            <span class="text-gray-400 dark:text-gray-500 italic text-xs">Tidak ada</span>
                        @endif
                    </span>
                </div>
            </div>
        </div>

        <!-- Account Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-1.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                    <i class="fas fa-info-circle text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Akun</h3>
            </div>
            <div class="space-y-2">
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">User ID</span>
                    <span class="text-sm font-mono text-gray-900 dark:text-gray-100">#{{ $user->id }}</span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Terdaftar</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        {{ $user->created_at->format('d/m/Y') }}
                        <span class="text-xs text-gray-500 dark:text-gray-400 ml-1">{{ $user->created_at->format('H:i') }}</span>
                    </span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Terakhir Diupdate</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        {{ $user->updated_at->format('d/m/Y') }}
                        <span class="text-xs text-gray-500 dark:text-gray-400 ml-1">{{ $user->updated_at->format('H:i') }}</span>
                    </span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Last Login</span>
                    <span class="text-sm text-gray-900 dark:text-gray-100">
                        @if($user->last_login_at)
                            {{ $user->last_login_at->format('d/m/Y') }}
                            <span class="text-xs text-gray-500 dark:text-gray-400 ml-1">{{ $user->last_login_at->format('H:i') }}</span>
                        @else
                            <span class="text-gray-400 dark:text-gray-500 italic text-xs">Belum pernah login</span>
                        @endif
                    </span>
                </div>
                <div>
                    <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Email Verified</span>
                    <div class="mt-0.5">
                        @if($user->email_verified_at)
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-200">
                                <i class="fas fa-check-circle mr-1 text-xs"></i> Terverifikasi
                            </span>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                {{ $user->email_verified_at->format('d/m/Y H:i') }}
                            </p>
                        @else
                            <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-yellow-100 dark:bg-yellow-900/40 text-yellow-800 dark:text-yellow-200">
                                <i class="fas fa-exclamation-circle mr-1 text-xs"></i> Belum Terverifikasi
                            </span>
                        @endif
                    </div>
                </div>
                @if($user->must_change_password)
                    <div>
                        <span class="text-xs font-medium text-gray-500 dark:text-gray-400 block mb-0.5">Password Status</span>
                        <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md bg-orange-100 dark:bg-orange-900/40 text-orange-800 dark:text-orange-200">
                            <i class="fas fa-key mr-1 text-xs"></i> Wajib Ganti Password
                        </span>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    @if(!$user->isAdmin())
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-3 transition-colors duration-300">
            <div class="flex flex-wrap items-center justify-between gap-2">
                <div class="flex items-center space-x-2">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400">Aksi Cepat:</span>
                </div>
                <div class="flex flex-wrap items-center gap-2">
                    <form action="{{ route('admin.users.toggle-status', $user->id) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit"
                            class="px-3 py-1.5 {{ $user->is_active ? 'bg-orange-500 hover:bg-orange-600' : 'bg-green-500 hover:bg-green-600' }} text-white text-sm font-medium rounded-lg transition-colors duration-200 flex items-center space-x-1.5"
                            onclick="return confirm('Yakin ingin {{ $user->is_active ? 'menonaktifkan' : 'mengaktifkan' }} user ini?');">
                            <i class="fas fa-{{ $user->is_active ? 'ban' : 'check' }} text-xs"></i>
                            <span class="text-xs">{{ $user->is_active ? 'Nonaktifkan' : 'Aktifkan' }}</span>
                        </button>
                    </form>
                    <form action="{{ route('admin.users.reset-password', $user->id) }}" method="POST" class="inline"
                        onsubmit="return confirm('Yakin ingin mereset password user ini? Password baru akan dikirim via email.');">
                        @csrf
                        <button type="submit"
                            class="px-3 py-1.5 bg-yellow-500 hover:bg-yellow-600 text-white text-sm font-medium rounded-lg transition-colors duration-200 flex items-center space-x-1.5">
                            <i class="fas fa-key text-xs"></i>
                            <span class="text-xs">Reset Password</span>
                        </button>
                    </form>
                    <button onclick="confirmDelete({{ $user->id }})"
                        class="px-3 py-1.5 bg-red-500 hover:bg-red-600 text-white text-sm font-medium rounded-lg transition-colors duration-200 flex items-center space-x-1.5">
                        <i class="fas fa-trash text-xs"></i>
                        <span class="text-xs">Hapus User</span>
                    </button>
                    <form id="delete-form-{{ $user->id }}"
                        action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="hidden">
                        @csrf
                        @method('DELETE')
                    </form>
                </div>
            </div>
        </div>
    @else
        <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg p-3">
            <div class="flex items-start">
                <i class="fas fa-exclamation-triangle text-yellow-600 dark:text-yellow-400 mr-2 mt-0.5 text-sm"></i>
                <div>
                    <p class="text-xs font-medium text-yellow-900 dark:text-yellow-200 mb-0.5">User Admin</p>
                    <p class="text-xs text-yellow-800 dark:text-yellow-300">
                        User dengan role Admin tidak dapat dimodifikasi melalui menu Management User. Hanya 1 admin yang diizinkan dalam sistem.
                    </p>
                </div>
            </div>
        </div>
    @endif

    <script>
        function confirmDelete(id) {
            if (confirm('Yakin ingin menghapus user ini? Tindakan ini tidak dapat dibatalkan!')) {
                document.getElementById('delete-form-' + id).submit();
            }
        }
    </script>
@endsection

