@extends('layouts.auth')

@section('title', __('Verify Email'))
@section('subtitle', __('One last step to activate your account'))

@section('content')
    <!-- Info Message -->
    <div class="mb-4 p-3 bg-blue-50 border border-blue-200 rounded-lg flex items-start">
        <svg class="h-4 w-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd"
                d="M18 5v8a2 2 0 01-2 2h-5l-5 4v-4H4a2 2 0 01-2-2V5a2 2 0 012-2h12a2 2 0 012 2zm-11-1a1 1 0 11-2 0 1 1 0 012 0zM8 7a1 1 0 000 2h6a1 1 0 100-2H8zm6 4a1 1 0 100-2H8a1 1 0 100 2h6z"
                clip-rule="evenodd"></path>
        </svg>
        <p class="text-xs text-blue-800 leading-relaxed">
            {{ __('Thanks for signing up! We\'ve sent a verification link to your email. Please click the link to verify your account.') }}
        </p>
    </div>

    <!-- Verification Link Sent Alert -->
    @if (session('status') == 'verification-link-sent')
        <div class="mb-4 p-3 bg-emerald-50 border border-emerald-200 rounded-lg flex items-start">
            <svg class="h-4 w-4 text-emerald-600 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd"
                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                    clip-rule="evenodd"></path>
            </svg>
            <p class="text-xs text-emerald-800 font-medium">
                {{ __('A new verification link has been sent to your email address.') }}
            </p>
        </div>
    @endif

    <!-- Action Buttons -->
    <div class="space-y-3 mt-6">
        <!-- Resend Verification Email Button -->
        <form method="POST" action="{{ route('verification.send') }}">
            @csrf
            <button type="submit"
                class="w-full bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-bold py-2 px-4 rounded-lg transition duration-300 transform hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 shadow-md text-xs flex items-center justify-center">
                <svg class="h-3.5 w-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                    </path>
                </svg>
                {{ __('Resend Verification Email') }}
            </button>
        </form>

        <!-- Log Out Button -->
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit"
                class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 font-semibold py-2 px-4 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:ring-offset-2 text-xs flex items-center justify-center">
                <svg class="h-3.5 w-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1">
                    </path>
                </svg>
                {{ __('Log Out') }}
            </button>
        </form>
    </div>
@endsection

@section('footer_links')
    <div class="border-t border-gray-200 pt-3 text-center">
        <p class="text-gray-700 text-xs">
            {{ __('Didn\'t receive the email?') }}
            <span class="text-gray-600">{{ __('Check your spam folder or resend above.') }}</span>
        </p>
    </div>
@endsection

@section('additional_info')
    📧 Email Verification Required
@endsection
