@props(['type' => 'success', 'message' => '', 'autoClose' => true, 'duration' => 5000])

@php
    $config = [
        'success' => [
            'bg' => 'bg-gradient-to-r from-emerald-500 to-green-600',
            'icon' => 'fa-check-circle',
            'iconBg' => 'bg-white/20',
        ],
        'error' => [
            'bg' => 'bg-gradient-to-r from-red-500 to-rose-600',
            'icon' => 'fa-exclamation-circle',
            'iconBg' => 'bg-white/20',
        ],
        'warning' => [
            'bg' => 'bg-gradient-to-r from-amber-500 to-orange-600',
            'icon' => 'fa-exclamation-triangle',
            'iconBg' => 'bg-white/20',
        ],
        'info' => [
            'bg' => 'bg-gradient-to-r from-blue-500 to-indigo-600',
            'icon' => 'fa-info-circle',
            'iconBg' => 'bg-white/20',
        ],
    ];
    
    $style = $config[$type] ?? $config['success'];
@endphp

<div x-data="{ show: true }" 
     x-show="show" 
     x-transition:enter="transition transform ease-out duration-500"
     x-transition:enter-start="-translate-y-10 opacity-0" 
     x-transition:enter-end="translate-y-0 opacity-100"
     x-transition:leave="transition transform ease-in duration-500"
     x-transition:leave-start="translate-y-0 opacity-100" 
     x-transition:leave-end="-translate-y-10 opacity-0"
     @if($autoClose)
     x-init="setTimeout(() => show = false, {{ $duration }})"
     @endif
     class="fixed top-6 right-6 z-50 w-[90%] sm:w-[420px] {{ $style['bg'] }} text-white shadow-2xl rounded-xl px-6 py-4 flex items-center justify-between space-x-3">
    <div class="flex items-center space-x-3 flex-1">
        <div class="flex items-center justify-center w-10 h-10 {{ $style['iconBg'] }} rounded-full flex-shrink-0">
            <i class="fas {{ $style['icon'] }} text-white text-lg"></i>
        </div>
        <div class="flex-1">
            <p class="font-semibold text-sm sm:text-base">{{ $message }}</p>
        </div>
    </div>
    <button @click="show = false" 
            class="hover:bg-white/20 rounded-full p-1.5 transition duration-200 flex-shrink-0">
        <i class="fas fa-times text-white text-sm"></i>
    </button>
</div>

