{{-- 
    Komponen Tabel Gabungan Bahan & Sparepart
    Props: $production, $canEdit (boolean), $canCheckReceived (boolean), $showActions (boolean)
--}}

@php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $canEdit = $canEdit ?? false;
    $canCheckReceived = $canCheckReceived ?? false;
    $showActions = $showActions ?? false;
    
    // Gabungkan materials dan spareparts
    $allItems = collect();
    
    foreach($production->productionMaterials as $pm) {
        $totalNeeded = $pm->quantity * $orderQty;
        $currentStock = $pm->material->stock ?? 0;
        
        $allItems->push([
            'id' => $pm->id,
            'type' => 'material',
            'type_label' => 'Bahan',
            'name' => $pm->material->name ?? 'N/A',
            'quantity' => $pm->quantity,
            'unit' => $pm->unit,
            'unit_cost' => $pm->unit_cost,
            'total_cost' => $pm->total_cost,
            'stock' => $currentStock,
            'total_needed' => $totalNeeded,
            'stock_ok' => $currentStock >= $totalNeeded,
            'is_received' => $pm->is_received ?? false,
            'is_admin_suggested' => $pm->is_admin_suggested ?? false,
            'revised_at' => $pm->revised_by_teknisi_at,
            'model' => $pm,
        ]);
    }
    
    foreach($production->productionSpareparts as $ps) {
        $totalNeeded = $ps->quantity * $orderQty;
        $currentStock = $ps->sparepart->stock ?? 0;
        
        $allItems->push([
            'id' => $ps->id,
            'type' => 'sparepart',
            'type_label' => 'Sparepart',
            'name' => $ps->sparepart->name ?? 'N/A',
            'quantity' => $ps->quantity,
            'unit' => $ps->unit,
            'unit_cost' => $ps->unit_cost,
            'total_cost' => $ps->total_cost,
            'stock' => $currentStock,
            'total_needed' => $totalNeeded,
            'stock_ok' => $currentStock >= $totalNeeded,
            'is_received' => $ps->is_received ?? false,
            'is_admin_suggested' => $ps->is_admin_suggested ?? false,
            'revised_at' => $ps->revised_by_teknisi_at,
            'model' => $ps,
        ]);
    }
    
    $totalCost = $allItems->sum('total_cost');
    $totalMaterial = $production->productionMaterials->sum('total_cost');
    $totalSparepart = $production->productionSpareparts->sum('total_cost');
@endphp

<div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
    {{-- Header --}}
    <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-750">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-slate-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-layer-group text-white"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Daftar Bahan & Sparepart</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ $allItems->count() }} item  {{ $orderQty }} unit produk</p>
                </div>
            </div>
            <div class="text-right">
                <p class="text-xs text-gray-500 dark:text-gray-400">Total Biaya</p>
                <p class="text-lg font-bold text-gray-900 dark:text-white">Rp {{ number_format($totalCost, 0, ',', '.') }}</p>
            </div>
        </div>
    </div>

    {{-- Table --}}
    @if($allItems->count() > 0)
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 dark:bg-gray-700/50">
                <tr class="text-xs uppercase tracking-wider">
                    @if($canCheckReceived)
                    <th class="px-4 py-3 text-center font-semibold text-gray-600 dark:text-gray-300 w-16">Terima</th>
                    @endif
                    <th class="px-4 py-3 text-left font-semibold text-gray-600 dark:text-gray-300 w-24">Tipe</th>
                    <th class="px-4 py-3 text-left font-semibold text-gray-600 dark:text-gray-300">Nama Item</th>
                    <th class="px-4 py-3 text-center font-semibold text-gray-600 dark:text-gray-300 w-20">Jumlah</th>
                    <th class="px-4 py-3 text-center font-semibold text-gray-600 dark:text-gray-300 w-20">Satuan</th>
                    <th class="px-4 py-3 text-right font-semibold text-gray-600 dark:text-gray-300 w-28">Harga Satuan</th>
                    <th class="px-4 py-3 text-right font-semibold text-gray-600 dark:text-gray-300 w-28">Total</th>
                    <th class="px-4 py-3 text-center font-semibold text-gray-600 dark:text-gray-300 w-24">Stok</th>
                    @if($showActions)
                    <th class="px-4 py-3 text-center font-semibold text-gray-600 dark:text-gray-300 w-20">Aksi</th>
                    @endif
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                @foreach($allItems as $item)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 transition-colors">
                    @if($canCheckReceived)
                    <td class="px-4 py-3 text-center">
                        <input type="checkbox" 
                               class="w-4 h-4 text-slate-600 bg-white border-gray-300 rounded focus:ring-slate-500 cursor-pointer"
                               data-type="{{ $item['type'] }}"
                               data-id="{{ $item['id'] }}"
                               {{ $item['is_received'] ? 'checked' : '' }}
                               onchange="toggleItemReceived(this, '{{ $item['type'] }}', {{ $item['id'] }})">
                    </td>
                    @endif
                    <td class="px-4 py-3">
                        @if($item['type'] === 'material')
                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded bg-slate-100 dark:bg-slate-800 text-slate-700 dark:text-slate-300">
                            <i class="fas fa-cube mr-1.5 text-slate-500"></i>Bahan
                        </span>
                        @else
                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300">
                            <i class="fas fa-cog mr-1.5 text-gray-500"></i>Sparepart
                        </span>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        <div class="font-medium text-gray-900 dark:text-white">{{ $item['name'] }}</div>
                        @if($item['is_admin_suggested'])
                        <span class="inline-flex items-center text-xs text-blue-600 dark:text-blue-400 mt-0.5">
                            <i class="fas fa-user-shield mr-1"></i>Admin
                        </span>
                        @endif
                        @if($item['revised_at'])
                        <span class="inline-flex items-center text-xs text-amber-600 dark:text-amber-400 mt-0.5 ml-2">
                            <i class="fas fa-edit mr-1"></i>Direvisi
                        </span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-center font-medium text-gray-900 dark:text-white">
                        {{ $item['quantity'] }}
                    </td>
                    <td class="px-4 py-3 text-center text-gray-600 dark:text-gray-400">
                        {{ $item['unit'] }}
                    </td>
                    <td class="px-4 py-3 text-right text-gray-600 dark:text-gray-400">
                        Rp {{ number_format($item['unit_cost'], 0, ',', '.') }}
                    </td>
                    <td class="px-4 py-3 text-right font-semibold text-gray-900 dark:text-white">
                        Rp {{ number_format($item['total_cost'], 0, ',', '.') }}
                    </td>
                    <td class="px-4 py-3 text-center">
                        @if($item['stock_ok'])
                        <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-green-50 dark:bg-green-900/30 text-green-700 dark:text-green-400">
                            {{ $item['stock'] }}
                        </span>
                        @else
                        <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-red-50 dark:bg-red-900/30 text-red-700 dark:text-red-400">
                            {{ $item['stock'] }}
                        </span>
                        @endif
                    </td>
                    @if($showActions)
                    <td class="px-4 py-3 text-center">
                        <div class="flex items-center justify-center gap-1">
                            @if($item['is_admin_suggested'] && $canEdit)
                            <button type="button" 
                                    data-{{ $item['type'] }}-id="{{ $item['id'] }}"
                                    onclick="revise{{ ucfirst($item['type']) }}({{ $item['id'] }})"
                                    class="p-1.5 text-gray-500 hover:text-amber-600 hover:bg-amber-50 dark:hover:bg-amber-900/20 rounded transition-colors"
                                    title="Revisi">
                                <i class="fas fa-edit text-sm"></i>
                            </button>
                            @endif
                            @if($canEdit)
                            <button type="button"
                                    data-{{ $item['type'] }}-id="{{ $item['id'] }}"
                                    onclick="delete{{ ucfirst($item['type']) }}({{ $item['id'] }})"
                                    class="p-1.5 text-gray-500 hover:text-red-600 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors"
                                    title="Hapus">
                                <i class="fas fa-trash text-sm"></i>
                            </button>
                            @endif
                        </div>
                    </td>
                    @endif
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    {{-- Footer Summary --}}
    <div class="px-5 py-3 bg-gray-50 dark:bg-gray-750 border-t border-gray-200 dark:border-gray-700">
        <div class="flex items-center justify-between text-sm">
            <div class="flex items-center gap-6">
                <span class="text-gray-600 dark:text-gray-400">
                    <i class="fas fa-cube mr-1.5 text-slate-500"></i>Bahan: 
                    <span class="font-medium text-gray-900 dark:text-white">Rp {{ number_format($totalMaterial, 0, ',', '.') }}</span>
                </span>
                <span class="text-gray-600 dark:text-gray-400">
                    <i class="fas fa-cog mr-1.5 text-gray-500"></i>Sparepart: 
                    <span class="font-medium text-gray-900 dark:text-white">Rp {{ number_format($totalSparepart, 0, ',', '.') }}</span>
                </span>
            </div>
            <div class="font-semibold text-gray-900 dark:text-white">
                Total: Rp {{ number_format($totalCost, 0, ',', '.') }}
            </div>
        </div>
    </div>
    @else
    <div class="px-5 py-12 text-center">
        <div class="w-16 h-16 mx-auto bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
            <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
        </div>
        <p class="text-gray-600 dark:text-gray-400 font-medium">Belum ada bahan atau sparepart</p>
        <p class="text-sm text-gray-500 dark:text-gray-500 mt-1">Data akan muncul setelah teknisi melakukan planning</p>
    </div>
    @endif
</div>

