<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfirmasi Serah Terima Produk</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .content {
            padding: 30px 20px;
        }
        .title {
            font-size: 20px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 15px 0;
        }
        .message {
            font-size: 16px;
            color: #4b5563;
            margin: 0 0 20px 0;
            line-height: 1.6;
        }
        .info-box {
            background-color: #f0fdf4;
            border-left: 4px solid #10b981;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-item {
            margin: 8px 0;
            font-size: 14px;
        }
        .info-label {
            font-weight: 600;
            color: #374151;
            display: inline-block;
            min-width: 120px;
        }
        .info-value {
            color: #6b7280;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .button {
            display: inline-block;
            padding: 14px 32px;
            background-color: #10b981;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        .button:hover {
            background-color: #059669;
        }
        .link-box {
            background-color: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            word-break: break-all;
        }
        .link-box code {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            color: #3b82f6;
        }
        .footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
            font-size: 12px;
            color: #6b7280;
        }
        .warning-box {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            font-size: 14px;
            color: #92400e;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎉 Produk Telah Diserahkan!</h1>
        </div>
        <div class="content">
            <h2 class="title">Halo {{ $order->customer_name }}!</h2>
            <p class="message">
                Kami dengan senang hati memberitahukan bahwa produk pesanan Anda telah siap dan telah diserahkan.
            </p>
            
            <div class="info-box">
                <h3 style="margin-top: 0; font-size: 16px; font-weight: 600; color: #374151; margin-bottom: 12px;">Detail Pesanan:</h3>
                <div class="info-item">
                    <span class="info-label">Order ID:</span>
                    <span class="info-value">#{{ $order->id }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Produk:</span>
                    <span class="info-value">{{ $order->product->product_title ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Jumlah:</span>
                    <span class="info-value">{{ $order->quantity }} unit</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Total Harga:</span>
                    <span class="info-value">Rp {{ number_format($order->total_price, 0, ',', '.') }}</span>
                </div>
            </div>

            <div class="warning-box">
                <strong>⚠️ Penting:</strong> Silakan konfirmasi penerimaan produk Anda melalui link di bawah ini. 
                Konfirmasi ini diperlukan untuk menyelesaikan proses penjualan.
            </div>

            <div class="button-container">
                <a href="{{ route('user.orders.confirm-delivery', $order) }}" class="button">
                    ✅ Konfirmasi Penerimaan Produk
                </a>
            </div>

            <div class="link-box">
                <p style="margin: 0 0 8px 0; font-size: 12px; color: #6b7280; font-weight: 600;">Atau salin link berikut:</p>
                <code>{{ route('user.orders.confirm-delivery', $order) }}</code>
            </div>

            <p style="font-size: 14px; color: #6b7280; margin-top: 20px;">
                Jika Anda mengalami kendala atau memiliki pertanyaan, jangan ragu untuk menghubungi kami.
            </p>
        </div>
        <div class="footer">
            <p>Email ini dikirim secara otomatis dari sistem POLJAM TECH.</p>
            <p>Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</p>
            <p>&copy; {{ date('Y') }} POLJAM TECH. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

