<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Akun Baru Dibuat</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #dbeafe;
            border-left: 4px solid #3b82f6;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-box strong {
            color: #1e40af;
        }
        .credentials-box {
            background-color: #f3f4f6;
            border: 2px solid #6b7280;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .credential-item {
            margin: 15px 0;
        }
        .credential-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
            display: block;
        }
        .credential-value {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            font-family: 'Courier New', monospace;
            background-color: #ffffff;
            padding: 10px;
            border-radius: 4px;
            border: 1px solid #d1d5db;
        }
        .password-value {
            font-size: 20px;
            letter-spacing: 2px;
        }
        .warning {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .warning strong {
            color: #92400e;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #10b981;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
            font-weight: 600;
        }
        .button:hover {
            background-color: #059669;
        }
        .footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            color: #6b7280;
            font-size: 12px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>POLJAM TECH</h1>
        </div>
        <div class="content">
            <h2>Selamat! Akun Anda Telah Dibuat</h2>
            <p>Halo <strong>{{ $user->name }}</strong>,</p>
            
            <p>Administrator telah membuat akun untuk Anda di sistem POLJAM TECH. Berikut adalah kredensial login Anda:</p>

            <div class="info-box">
                <strong>ℹ️ INFORMASI AKUN:</strong>
                <ul>
                    <li><strong>Role:</strong> {{ ucfirst($user->user_type) }}</li>
                    <li><strong>Status:</strong> {{ $user->is_active ? 'Aktif' : 'Tidak Aktif' }}</li>
                </ul>
            </div>

            <div class="credentials-box">
                <div class="credential-item">
                    <span class="credential-label">Email / Username:</span>
                    <div class="credential-value">{{ $user->email }}</div>
                </div>
                <div class="credential-item">
                    <span class="credential-label">Password:</span>
                    <div class="credential-value password-value">{{ $password }}</div>
                </div>
            </div>

            <div class="warning">
                <strong>🔒 PENTING - KEAMANAN AKUN:</strong>
                <ul>
                    <li>Anda <strong>WAJIB</strong> mengganti password ini saat login pertama kali</li>
                    <li>Sistem akan memaksa Anda untuk mengganti password sebelum dapat mengakses fitur lainnya</li>
                    <li>Jangan bagikan kredensial ini kepada siapapun</li>
                    <li>Gunakan password yang kuat dan unik (minimal 8 karakter, kombinasi huruf dan angka)</li>
                    <li>Jangan gunakan password yang sama dengan akun lain</li>
                </ul>
            </div>

            <p style="margin-top: 30px;">
                <a href="{{ route('login') }}" class="button">Login Sekarang</a>
            </p>

            <p style="margin-top: 30px; color: #6b7280; font-size: 14px;">
                <strong>Catatan:</strong> Jika Anda tidak mengharapkan email ini atau memiliki pertanyaan, silakan hubungi administrator sistem.
            </p>
        </div>
        <div class="footer">
            <p>Email ini dikirim secara otomatis oleh sistem POLJAM TECH. Jangan balas email ini.</p>
            <p>&copy; {{ date('Y') }} POLJAM TECH. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

