<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reply dari POLJAM TECH</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #2563eb;
            margin-bottom: 10px;
        }
        .subject {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 20px;
        }
        .message {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #2563eb;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }
        .inquiry-info {
            background-color: #f0f9ff;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .product-info {
            background-color: #f0fdf4;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">POLJAM TECH</div>
            <p>Terima kasih atas pertanyaan Anda!</p>
        </div>

        <div class="subject">
            Re: {{ $subject }}
        </div>

        <div class="inquiry-info">
            <strong>Pertanyaan asli dari:</strong><br>
            Nama: {{ $inquiry->name }}<br>
            Email: {{ $inquiry->email }}<br>
            Telepon: {{ $inquiry->phone }}<br>
            Tanggal: {{ $inquiry->created_at->format('d M Y H:i') }}
        </div>

        <div class="product-info">
            <strong>Produk yang ditanyakan:</strong><br>
            {{ $inquiry->product->product_title ?? 'Produk tidak ditemukan' }}
        </div>

        <div class="message">
            <strong>Balasan dari tim POLJAM TECH:</strong><br><br>
            @php
                $replyText = $reply_message ?? '';
                if (!is_string($replyText)) {
                    $replyText = (string) $replyText;
                }
            @endphp
            {!! nl2br(e($replyText)) !!}
        </div>

        <div class="footer">
            <p>
                <strong>POLJAM TECH</strong><br>
                Jl. Teknologi No. 123, Jakarta<br>
                Email: info@poljamtech.com<br>
                Telp: (021) 1234-5678
            </p>
            <p style="margin-top: 15px; font-size: 12px;">
                Email ini dikirim secara otomatis. Mohon tidak membalas email ini.
            </p>
        </div>
    </div>
</body>
</html>
