@extends('layouts.main')

@section('title', 'Hubungi Kami')

@section('content')
<section class="py-6 sm:py-8 lg:py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header Section -->
        <div class="text-center mb-8 sm:mb-10">
            <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2 sm:mb-3">Hubungi Kami</h2>
            <p class="text-sm sm:text-base text-gray-600">
                Kami siap membantu Anda. Hubungi kami melalui berbagai saluran komunikasi yang tersedia atau kunjungi kantor kami.
            </p>
        </div>

        <!-- Main Content Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">
            <!-- Contact Information Card -->
            <div class="bg-white rounded-2xl shadow-xl p-6 sm:p-8 hover:shadow-2xl">
                <div class="flex items-center mb-6">
                    <div class="p-2.5 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-lg mr-3">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                    <h2 class="text-xl sm:text-2xl font-bold text-gray-900">Informasi Kontak</h2>
                </div>

                <div class="space-y-4">
                    <!-- Address -->
                    <div class="group flex items-start p-3 rounded-lg hover:bg-blue-50 transition-colors duration-200">
                        <div class="flex-shrink-0 p-2.5 bg-blue-100 rounded-lg group-hover:bg-blue-200 transition-colors duration-200">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-3 flex-1">
                            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Alamat</h3>
                            <p class="text-sm text-gray-900 leading-relaxed">Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</p>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="group flex items-start p-3 rounded-lg hover:bg-blue-50 transition-colors duration-200">
                        <div class="flex-shrink-0 p-2.5 bg-cyan-100 rounded-lg group-hover:bg-cyan-200 transition-colors duration-200">
                            <svg class="w-5 h-5 text-cyan-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div class="ml-3 flex-1">
                            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Email</h3>
                            <a href="mailto:info@poljamtech.com" class="text-sm text-blue-600 hover:text-blue-800 font-medium transition-colors duration-200">
                                info@poljamtech.com
                            </a>
                        </div>
                    </div>

                    <!-- Phone -->
                    <div class="group flex items-start p-3 rounded-lg hover:bg-blue-50 transition-colors duration-200">
                        <div class="flex-shrink-0 p-2.5 bg-green-100 rounded-lg group-hover:bg-green-200 transition-colors duration-200">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                        </div>
                        <div class="ml-3 flex-1">
                            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Telepon</h3>
                            <a href="tel:+621234567890" class="text-sm text-gray-900 hover:text-blue-600 font-medium transition-colors duration-200">
                                +62 123 456 7890
                            </a>
                        </div>
                    </div>

                    <!-- Working Hours -->
                    <div class="group flex items-start p-3 rounded-lg hover:bg-blue-50 transition-colors duration-200">
                        <div class="flex-shrink-0 p-2.5 bg-purple-100 rounded-lg group-hover:bg-purple-200 transition-colors duration-200">
                            <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-3 flex-1">
                            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Jam Kerja</h3>
                            <p class="text-sm text-gray-900 font-medium">Senin - Jumat</p>
                            <p class="text-xs text-gray-600">08:00 - 17:00 WIB</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Map Card -->
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden hover:shadow-2xl">
                <div class="p-6 sm:p-8 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="p-2.5 bg-gradient-to-br from-cyan-500 to-blue-500 rounded-lg mr-3">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                        </div>
                        <h2 class="text-xl sm:text-2xl font-bold text-gray-900">Lokasi Kami</h2>
                    </div>
                </div>
                <div class="relative w-full h-80 sm:h-96 lg:h-[500px]">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3988.181331738691!2d103.55157217364946!3d-1.6413407361144894!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e2587f1c448d267%3A0x3b67564f9f182d66!2sPoliteknik%20Jambi!5e0!3m2!1sid!2sus!4v1756465889538!5m2!1sid!2sus" 
                        width="100%" 
                        height="100%" 
                        style="border:0;" 
                        allowfullscreen="" 
                        loading="lazy"
                        class="rounded-b-2xl"
                    ></iframe>
                    <div class="absolute inset-0 bg-gradient-to-t from-white/10 to-transparent pointer-events-none rounded-b-2xl"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    /* Smooth animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .animate-fade-in-up {
        animation: fadeInUp 0.6s ease-out;
    }

    /* Custom scrollbar for better UX */
    ::-webkit-scrollbar {
        width: 8px;
    }

    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    ::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
</style>
@endsection
