@extends('layouts.main') {{-- Ganti ke 'layouts.app' jika beda --}}

@section('title', 'Pesanan Berhasil')

@section('content')
    <div class="min-h-screen py-6 sm:py-8 lg:py-12">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2">
                    @if($order->payment_method === 'dp')
                        Pesanan DP Berhasil Dibuat
                    @else
                        Pesanan Berhasil
                    @endif
                </h1>
                <p class="text-sm sm:text-base text-gray-600">
                    @if($order->payment_method === 'dp')
                        Pesanan Anda telah berhasil dibuat. Silakan lakukan pembayaran DP untuk melanjutkan proses produksi.
                    @else
                        Pesanan Anda telah berhasil dibuat. Terima kasih atas kepercayaan Anda.
                    @endif
                </p>
            </div>

            @if($order->payment_method === 'dp')
                <!-- Alert Sukses untuk DP -->
                <div class="mb-6 p-4 bg-orange-50 border-l-4 border-orange-500 rounded">
                    <div class="flex items-center">
                        <svg class="h-5 w-5 text-orange-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                        </svg>
                        <p class="text-sm font-medium text-orange-800">
                            Silakan lakukan pembayaran DP terlebih dahulu untuk melanjutkan proses produksi.
                        </p>
                    </div>
                </div>

                @php
                    // Hitung DP berdasarkan dp_percentage dari order (default 30% jika null)
                    $dpPercentage = $order->dp_percentage ?? 30.00;
                    $dpAmount = $order->total_price * ($dpPercentage / 100);
                    $remainingAmount = $order->total_price - $dpAmount;
                @endphp

                <!-- Single Card Container untuk DP -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                    <!-- Informasi Pembayaran DP -->
                    <div class="p-6 border-b border-gray-200 bg-blue-50">
                        <h2 class="text-lg font-semibold text-gray-900">Informasi Pembayaran DP</h2>
                    </div>
                    
                    <div class="p-6 space-y-4">
                        <!-- Total Harga Pesanan -->
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">Total Harga Pesanan</span>
                            <span class="text-sm font-medium text-gray-900">{{ $order->formatted_total_price }}</span>
                        </div>

                        <!-- DP yang Harus Dibayar -->
                        <div class="flex justify-between items-center py-2.5 bg-orange-50 px-3 rounded border border-orange-100">
                            <span class="text-sm text-orange-700 font-medium">DP ({{ number_format($dpPercentage, 0) }}%)</span>
                            <span class="text-base font-bold text-orange-600">Rp{{ number_format($dpAmount, 0, ',', '.') }}</span>
                        </div>

                        <!-- Sisa Pembayaran -->
                        <div class="flex justify-between items-center py-2">
                            <span class="text-sm text-gray-600">Sisa Pembayaran</span>
                            <span class="text-sm font-medium text-gray-900">Rp{{ number_format($remainingAmount, 0, ',', '.') }}</span>
                        </div>
                    </div>

                    <!-- Instruksi Pembayaran -->
                    <div class="border-t border-gray-200 p-6 bg-yellow-50">
                        <div class="flex items-start">
                            <svg class="h-5 w-5 text-yellow-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <h4 class="text-sm font-semibold text-yellow-900 mb-2">Cara Melakukan Pembayaran DP:</h4>
                                <ol class="list-decimal list-inside space-y-1.5 text-xs text-yellow-800">
                                    <li>Lakukan transfer sebesar <strong>Rp{{ number_format($dpAmount, 0, ',', '.') }}</strong> ke rekening BSI.</li>
                                    <li>Upload bukti transfer melalui halaman <strong>"Pesanan Saya"</strong>.</li>
                                    <li>Setelah pembayaran DP dikonfirmasi, proses produksi akan dimulai.</li>
                                    <li>Sisa pembayaran dapat dilakukan saat mesin/produk sudah selesai.</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            @else
                <!-- Alert Sukses untuk Metode Lain -->
                <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-500 rounded">
                    <div class="flex items-center">
                        <svg class="h-5 w-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <p class="text-sm font-medium text-green-800">
                            @if (session('success'))
                                {{ session('success') }}
                            @else
                                Pesanan Anda telah berhasil dibuat. Terima kasih atas kepercayaan Anda.
                            @endif
                        </p>
                    </div>
                </div>
            @endif

            <!-- Detail Order -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-lg font-semibold text-gray-900">Detail Pesanan</h2>
                </div>
                <div class="p-6">
                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">ID Pesanan</span>
                            <span class="text-sm font-semibold text-gray-900">#{{ $order->id }}</span>
                        </div>
                        <div class="flex justify-between items-start py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">Produk</span>
                            <span class="text-sm font-medium text-gray-900 text-right max-w-xs">{{ $order->product->product_title ?? 'N/A' }}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">Quantity</span>
                            <span class="text-sm font-medium text-gray-900">{{ $order->quantity }}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">Total Harga</span>
                            <span class="text-sm font-medium text-blue-600">{{ $order->formatted_total_price }}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-600">Status</span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                {{ $order->status_label }}
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-2">
                            <span class="text-sm text-gray-600">Metode Pembayaran</span>
                            <span class="text-sm font-medium text-gray-900">{{ ucfirst($order->payment_method) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="mt-8 space-y-3">
                @if($order->payment_method === 'dp')
                    <a href="{{ route('my.orders.show', $order) }}"
                        class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                        Lihat Detail Pesanan & Upload Bukti DP
                    </a>
                @endif
            </div>

            <!-- Back Link -->
            <div class="mt-8 text-center">
                <a href="{{ route('all') }}" class="inline-flex items-center text-sm text-blue-600 hover:text-blue-800 font-medium">
                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                    </svg>
                    Kembali ke Daftar Produk
                </a>
            </div>
        </div>
    </div>

    @if($order->payment_method !== 'dp')
    <script>
        // Opsional: Refresh page setelah 5 detik untuk konfirmasi status terbaru (hanya untuk non-DP)
        setTimeout(() => {
            location.reload();
        }, 5000);
    </script>
    @endif
@endsection
