@props(['type' => 'success', 'message' => '', 'autoHide' => true, 'duration' => 4000])

@php
    $colors = [
        'success' => 'bg-green-500',
        'error' => 'bg-red-500',
        'warning' => 'bg-yellow-500',
        'info' => 'bg-blue-500',
    ];
    
    $icons = [
        'success' => 'fa-check-circle',
        'error' => 'fa-exclamation-circle',
        'warning' => 'fa-exclamation-triangle',
        'info' => 'fa-info-circle',
    ];
    
    $color = $colors[$type] ?? $colors['success'];
    $icon = $icons[$type] ?? $icons['success'];
@endphp

<div x-data="{ show: true }" 
     x-show="show" 
     x-transition:enter="transition ease-out duration-300"
     x-transition:enter-start="opacity-0 transform translate-y-[-10px]"
     x-transition:enter-end="opacity-100 transform translate-y-0"
     x-transition:leave="transition ease-in duration-300"
     x-transition:leave-start="opacity-100 transform translate-y-0"
     x-transition:leave-end="opacity-0 transform translate-y-[-10px]"
     @if($autoHide) x-init="setTimeout(() => show = false, {{ $duration }})" @endif
     class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] {{ $color }} text-white rounded-lg px-6 py-4 flex items-center justify-between space-x-3 shadow-lg">
    <div class="flex items-center space-x-3 flex-1">
        <i class="fas {{ $icon }} text-lg"></i>
        <div class="flex-1 font-medium text-sm">
            {{ $message }}
        </div>
    </div>
    <button @click="show = false" 
            class="hover:bg-white/20 rounded-full p-1 transition duration-200 flex-shrink-0">
        <i class="fas fa-times"></i>
    </button>
</div>

