@extends('layouts.supervisor')

@section('title', 'Dashboard Supervisor - POLJAM TECH')

@section('content')
<!-- Page Header -->
<div class="mb-6 sm:mb-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-2">Dashboard</h1>
    <p class="text-gray-600 dark:text-gray-400">Selamat datang kembali, {{ Auth::user()->name }}! Berikut ringkasan aktivitas dan monitoring sistem hari ini.</p>
</div>

@include('supervisor.partials.dashboard-stats-cards')
@include('supervisor.partials.dashboard-status-summaries')

<!-- Ringkasan Persetujuan -->
<div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700 mb-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Ringkasan Persetujuan</h2>
        <span class="text-sm text-gray-500 dark:text-gray-400">Quick Access</span>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <!-- Production Approvals Card -->
        <a href="{{ route('supervisor.productions.index') }}" 
           class="bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 rounded-lg border border-blue-200 dark:border-blue-800 p-6 hover:shadow-lg transition-all duration-200 group cursor-pointer">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-lg flex items-center justify-center text-white text-xl group-hover:scale-110 transition-transform">
                    <i class="fas fa-cogs"></i>
                </div>
                <div class="text-right">
                    <p class="text-3xl font-bold text-gray-900 dark:text-white">{{ ($stats['pending_planning_approvals'] ?? 0) + ($stats['pending_completion_approvals'] ?? 0) }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-400">
                        {{ $stats['pending_planning_approvals'] ?? 0 }} Planning
                        @if(($stats['pending_completion_approvals'] ?? 0) > 0)
                            <span class="mx-1">+</span> {{ $stats['pending_completion_approvals'] ?? 0 }} Completion
                        @endif
                    </p>
                </div>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Persetujuan Produksi</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">Tinjau dan setujui perencanaan & penyelesaian produksi dari teknisi</p>
            <div class="flex items-center text-blue-600 dark:text-blue-400 group-hover:text-blue-700 dark:group-hover:text-blue-300">
                <span class="text-sm font-medium">Lihat Detail</span>
                <i class="fas fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
            </div>
        </a>

        <!-- Purchase Approvals Card -->
        <a href="{{ route('supervisor.purchases.index') }}" 
           class="bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-900/20 dark:to-emerald-900/20 rounded-lg border border-green-200 dark:border-green-800 p-6 hover:shadow-lg transition-all duration-200 group cursor-pointer">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-600 rounded-lg flex items-center justify-center text-white text-xl group-hover:scale-110 transition-transform">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="text-right">
                    <p class="text-3xl font-bold text-gray-900 dark:text-white">{{ $stats['pending_purchase_approvals'] ?? 0 }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Tertunda</p>
                </div>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Persetujuan Pembelian</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">Tinjau dan setujui pesanan pembelian dari admin</p>
            <div class="flex items-center text-green-600 dark:text-green-400 group-hover:text-green-700 dark:group-hover:text-green-300">
                <span class="text-sm font-medium">Lihat Detail</span>
                <i class="fas fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
            </div>
        </a>
    </div>
</div>

@include('supervisor.partials.dashboard-recent-activities')
@endsection
