<!-- Recent Activities -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Recent Productions -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Produksi Terbaru
            </h3>
            <a href="{{ route('supervisor.monitoring.productions') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="space-y-3">
            @forelse($stats['recent_productions'] ?? [] as $production)
                <a href="{{ route('supervisor.monitoring.productions') }}" 
                   class="flex items-center justify-between p-4 bg-gradient-to-r from-gray-50 to-gray-100/50 dark:from-gray-700/30 dark:to-gray-700/20 rounded-lg transition-all border border-gray-200 dark:border-gray-600 group">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white truncate mb-1">
                            #{{ $production->id }} - {{ $production->product->product_title ?? 'N/A' }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <i class="fas fa-user text-gray-400 mr-1"></i>
                            {{ $production->order->customer_name ?? 'N/A' }} • 
                            <i class="fas fa-user-tie text-gray-400 ml-2 mr-1"></i>
                            {{ $production->teknisi->name ?? 'N/A' }} •
                            <i class="fas fa-calendar text-gray-400 ml-2 mr-1"></i>
                            {{ $production->updated_at ? $production->updated_at->format('d M Y') : 'N/A' }}
                        </p>
                    </div>
                    <div class="flex items-center gap-2 ml-3">
                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                            {{ $production->planning_status === 'approved' ? 'bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400' : 
                               ($production->planning_status === 'pending_approval' ? 'bg-yellow-100 text-yellow-700 dark:bg-yellow-900/30 dark:text-yellow-400' : 
                               ($production->planning_status === 'rejected' ? 'bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400' : 
                               'bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400')) }}">
                            {{ ucfirst(str_replace('_', ' ', $production->planning_status)) }}
                        </span>
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors"></i>
                    </div>
                </a>
            @empty
                <div class="text-center py-8">
                    <i class="fas fa-inbox text-gray-300 dark:text-gray-600 text-3xl mb-2"></i>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Tidak ada produksi terbaru</p>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Recent Orders -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400 mr-2"></i>
                Pesanan Terbaru
            </h3>
            <a href="{{ route('supervisor.monitoring.orders') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="space-y-3">
            @forelse($stats['recent_orders'] ?? [] as $order)
                <a href="{{ route('supervisor.monitoring.orders') }}" 
                   class="flex items-center justify-between p-4 bg-gradient-to-r from-gray-50 to-gray-100/50 dark:from-gray-700/30 dark:to-gray-700/20 rounded-lg transition-all border border-gray-200 dark:border-gray-600 group">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white truncate mb-1">
                            Order #{{ $order->id }} - {{ $order->product->product_title ?? 'N/A' }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <i class="fas fa-user text-gray-400 mr-1"></i>
                            {{ $order->customer_name ?? 'N/A' }} • 
                            <i class="fas fa-box text-gray-400 ml-2 mr-1"></i>
                            {{ $order->quantity }} unit •
                            <i class="fas fa-calendar text-gray-400 ml-2 mr-1"></i>
                            {{ $order->created_at ? $order->created_at->format('d M Y') : 'N/A' }}
                        </p>
                    </div>
                    <div class="flex items-center gap-2 ml-3">
                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                            @if($order->order_status === 'menunggu') bg-yellow-100 text-yellow-700 dark:bg-yellow-900/30 dark:text-yellow-400
                            @elseif($order->order_status === 'diterima') bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400
                            @elseif($order->order_status === 'dalam_proses') bg-indigo-100 text-indigo-700 dark:bg-indigo-900/30 dark:text-indigo-400
                            @elseif($order->order_status === 'selesai') bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400
                            @else bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400 @endif">
                            {{ ucfirst(str_replace('_', ' ', $order->order_status)) }}
                        </span>
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors"></i>
                    </div>
                </a>
            @empty
                <div class="text-center py-8">
                    <i class="fas fa-inbox text-gray-300 dark:text-gray-600 text-3xl mb-2"></i>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Tidak ada pesanan terbaru</p>
                </div>
            @endforelse
        </div>
    </div>
</div>

