@extends('layouts.supervisor')

@section('title', 'Laporan Keuangan - Supervisor')

@section('content')
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Keuangan</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Analisis dan monitoring laporan keuangan perusahaan
                    @if(request('start_date') || request('end_date'))
                        | Periode: 
                        {{ request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Awal' }} - 
                        {{ request('end_date') ? \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : 'Akhir' }}
                    @endif
                </p>
            </div>
        </div>
    </div>

    @if (session('error'))
        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        </div>
    @endif

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Pemasukan</p>
                    <h2 class="text-xl font-bold text-green-600 dark:text-green-400">Rp {{ number_format($totalIncome ?? 0, 0, ',', '.') }}</h2>
                </div>
                <div class="p-2.5 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-arrow-up text-green-600 dark:text-green-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Pengeluaran</p>
                    <h2 class="text-xl font-bold text-red-600 dark:text-red-400">Rp {{ number_format($totalExpense ?? 0, 0, ',', '.') }}</h2>
                </div>
                <div class="p-2.5 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-arrow-down text-red-600 dark:text-red-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Laba Bersih</p>
                    <h2 class="text-xl font-bold {{ ($netIncome ?? 0) >= 0 ? 'text-blue-600 dark:text-blue-400' : 'text-red-600 dark:text-red-400' }}">
                        Rp {{ number_format($netIncome ?? 0, 0, ',', '.') }}
                    </h2>
                </div>
                <div class="p-2.5 {{ ($netIncome ?? 0) >= 0 ? 'bg-blue-100 dark:bg-blue-900/40' : 'bg-red-100 dark:bg-red-900/40' }} rounded-lg">
                    <i class="fas fa-chart-line {{ ($netIncome ?? 0) >= 0 ? 'text-blue-600 dark:text-blue-400' : 'text-red-600 dark:text-red-400' }} text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Transaksi</p>
                    <h2 class="text-xl font-bold text-purple-600 dark:text-purple-400">{{ number_format($totalTransactions ?? 0, 0, ',', '.') }}</h2>
                </div>
                <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-receipt text-purple-600 dark:text-purple-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4 transition-colors duration-300">
        <div class="flex items-center mb-4">
            <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                <i class="fas fa-chart-line text-blue-600 dark:text-blue-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Trend Keuangan 12 Bulan Terakhir</h3>
        </div>
        <div class="relative h-80">
            <canvas id="financialChart"></canvas>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="{{ route('supervisor.reports.financial') }}" id="filterForm" class="space-y-4">
            <!-- Search Bar -->
            <div class="relative flex-1">
                <input type="text" name="search" id="searchInput" value="{{ request('search') }}" placeholder="Cari deskripsi, kategori, atau nomor referensi..."
                    class="form-input-search" />
                <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                @if (request('search'))
                    <button type="button" onclick="clearFilter('search')"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                        <i class="fas fa-times"></i>
                    </button>
                @endif
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="relative">
                    <input type="date" name="start_date" id="startDateInput" value="{{ request('start_date') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Mulai">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <input type="date" name="end_date" id="endDateInput" value="{{ request('end_date') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Akhir">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <select name="type" id="typeFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Tipe</option>
                        <option value="income" {{ request('type') == 'income' ? 'selected' : '' }}>Pemasukan</option>
                        <option value="expense" {{ request('type') == 'expense' ? 'selected' : '' }}>Pengeluaran</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <div class="flex items-center gap-2">
                    <button type="button" onclick="submitFilter()" class="flex-1 flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 h-10 text-sm">
                        <i class="fas fa-search mr-2 text-xs"></i>
                        Filter
                    </button>
                    @if (request()->hasAny(['search', 'start_date', 'end_date', 'type']))
                        <button type="button" onclick="clearAllFilters()" 
                           class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                           title="Reset filter">
                            <i class="fas fa-redo text-sm"></i>
                        </button>
                    @endif
                </div>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    @if (request()->hasAny(['search', 'start_date', 'end_date', 'type']))
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                @if (request('search'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "{{ request('search') }}"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('start_date') || request('end_date'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-800 dark:text-orange-200">
                        <i class="fas fa-calendar-alt mr-1"></i>
                        Periode: {{ request('start_date') ? date('d M Y', strtotime(request('start_date'))) : 'Awal' }} - {{ request('end_date') ? date('d M Y', strtotime(request('end_date'))) : 'Akhir' }}
                        <button onclick="clearDateFilter()" class="ml-2 hover:text-orange-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('type'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-filter mr-1"></i>
                        Tipe: {{ ucfirst(request('type')) }}
                        <button onclick="clearFilter('type')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Data Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-table text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Data Transaksi Keuangan</h3>
            </div>
        </div>
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tanggal</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tipe</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Kategori</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Deskripsi</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Nomor Referensi</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Jumlah</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Dibuat Oleh</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($transactions ?? [] as $transaction)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $transaction->transaction_date ? \Carbon\Carbon::parse($transaction->transaction_date)->format('d/m/Y') : '-' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium {{ $transaction->type == 'income' ? 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300' : 'bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300' }}">
                                    {{ $transaction->type == 'income' ? 'Pemasukan' : 'Pengeluaran' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $transaction->category_name ?? ucfirst(str_replace('_', ' ', $transaction->category ?? '-')) }}
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-white">{{ $transaction->description ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $transaction->reference_number ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold {{ $transaction->type == 'income' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }} text-right">
                                {{ $transaction->type == 'income' ? '+' : '-' }}Rp {{ number_format($transaction->amount ?? 0, 0, ',', '.') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $transaction->creator->name ?? '-' }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                        <i class="fas fa-chart-pie text-3xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data transaksi</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada data transaksi keuangan yang ditemukan.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if (isset($transactions) && $transactions->hasPages())
        <div class="mt-6 flex justify-center">
            {{ $transactions->onEachSide(1)->links() }}
        </div>
    @endif

    <script>
        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();
            
            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const startDate = document.getElementById('startDateInput')?.value || '';
            const endDate = document.getElementById('endDateInput')?.value || '';
            const type = document.getElementById('typeFilter')?.value || '';
            
            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (startDate) {
                params.append('start_date', startDate);
            }
            if (endDate) {
                params.append('end_date', endDate);
            }
            if (type) {
                params.append('type', type);
            }
            
            // Redirect dengan parameter yang bersih
            const url = '{{ route("supervisor.reports.financial") }}' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear date filter
        function clearDateFilter() {
            const url = new URL(window.location);
            url.searchParams.delete('start_date');
            url.searchParams.delete('end_date');
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '{{ route("supervisor.reports.financial") }}';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('financialChart');
    if (!ctx) return;
    
    const financialChart = new Chart(ctx.getContext('2d'), {
        type: 'line',
        data: {
            labels: {!! json_encode(isset($chartData) ? $chartData->map(function($item) { 
                return Carbon\Carbon::create($item->year ?? date('Y'), $item->month ?? 1, 1)->format('M Y'); 
            }) : []) !!},
            datasets: [{
                label: 'Total Pemasukan (Rp)',
                data: {!! json_encode(isset($chartData) ? $chartData->pluck('income')->map(function($val) { return $val ?? 0; }) : []) !!},
                borderColor: 'rgb(34, 197, 94)',
                backgroundColor: 'rgba(34, 197, 94, 0.1)',
                tension: 0.4,
                fill: true,
                borderWidth: 3,
                pointRadius: 5,
                pointHoverRadius: 8
            }, {
                label: 'Total Pengeluaran (Rp)',
                data: {!! json_encode(isset($chartData) ? $chartData->pluck('expense')->map(function($val) { return $val ?? 0; }) : []) !!},
                borderColor: 'rgb(239, 68, 68)',
                backgroundColor: 'rgba(239, 68, 68, 0.1)',
                tension: 0.4,
                fill: true,
                borderWidth: 3,
                pointRadius: 5,
                pointHoverRadius: 8
            }, {
                label: 'Laba Bersih (Rp)',
                data: {!! json_encode(isset($chartData) ? $chartData->map(function($item) { 
                    return ($item->income ?? 0) - ($item->expense ?? 0); 
                }) : []) !!},
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.4,
                fill: true,
                borderWidth: 3,
                pointRadius: 5,
                pointHoverRadius: 8,
                yAxisID: 'y1'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        padding: 20,
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.9)',
                    titleColor: 'white',
                    bodyColor: 'white',
                    borderColor: 'rgba(255, 255, 255, 0.1)',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: true,
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': Rp ' + context.parsed.y.toLocaleString('id-ID');
                        }
                    }
                }
            },
            scales: {
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'Pemasukan & Pengeluaran (Rp)',
                        color: '#6B7280',
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280',
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'Laba Bersih (Rp)',
                        color: '#6B7280',
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    },
                    grid: {
                        drawOnChartArea: false,
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280',
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 11
                        }
                    }
                }
            },
            animation: {
                duration: 1000,
                easing: 'easeInOutQuart'
            }
        }
    });
});
</script>
@endpush
@endsection

