<!-- Informasi Status & Progress -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Card 3: Progress Planning -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-tasks text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Progress Planning
            </h3>
        </div>
        <div class="space-y-4">
            @php
                $totalPlanning = ($stats['production_status_summary']['planning'] ?? 0) + 
                                 ($stats['production_status_summary']['pending_approval'] ?? 0) + 
                                 ($stats['production_status_summary']['approved'] ?? 0);
                $planningProgress = $totalPlanning > 0 ? (($stats['production_status_summary']['approved'] ?? 0) / $totalPlanning * 100) : 0;
            @endphp
            <div>
                <div class="flex items-center justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Planning Approved</span>
                    <span class="text-sm font-bold text-indigo-600 dark:text-indigo-400">{{ number_format($planningProgress, 1) }}%</span>
                </div>
                <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-3">
                    <div class="bg-gradient-to-r from-indigo-500 to-indigo-600 h-3 rounded-full transition-all duration-500" 
                         style="width: {{ min($planningProgress, 100) }}%"></div>
                </div>
            </div>
            <div class="grid grid-cols-3 gap-3 mt-4">
                <div class="text-center p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                    <p class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ $stats['production_status_summary']['planning'] ?? 0 }}</p>
                    <p class="text-xs text-blue-700 dark:text-blue-300 mt-1">Planning</p>
                </div>
                <div class="text-center p-3 bg-yellow-50 dark:bg-yellow-900/20 rounded-lg">
                    <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">{{ $stats['production_status_summary']['pending_approval'] ?? 0 }}</p>
                    <p class="text-xs text-yellow-700 dark:text-yellow-300 mt-1">Pending</p>
                </div>
                <div class="text-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg">
                    <p class="text-2xl font-bold text-green-600 dark:text-green-400">{{ $stats['production_status_summary']['approved'] ?? 0 }}</p>
                    <p class="text-xs text-green-700 dark:text-green-300 mt-1">Approved</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Card 4: Status Produksi -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-industry text-purple-600 dark:text-purple-400 mr-2"></i>
                Status Produksi
            </h3>
        </div>
        <div class="space-y-4">
            @php
                $totalStatus = ($stats['production_status_count']['menunggu'] ?? 0) + 
                               ($stats['production_status_count']['dalam_proses'] ?? 0) + 
                               ($stats['production_status_count']['selesai'] ?? 0);
                $activeProgress = $totalStatus > 0 ? (($stats['production_status_count']['dalam_proses'] ?? 0) / $totalStatus * 100) : 0;
            @endphp
            <div>
                <div class="flex items-center justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Produksi Aktif</span>
                    <span class="text-sm font-bold text-purple-600 dark:text-purple-400">{{ number_format($activeProgress, 1) }}%</span>
                </div>
                <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-3">
                    <div class="bg-gradient-to-r from-purple-500 to-purple-600 h-3 rounded-full transition-all duration-500" 
                         style="width: {{ min($activeProgress, 100) }}%"></div>
                </div>
            </div>
            <div class="grid grid-cols-3 gap-3 mt-4">
                <div class="text-center p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                    <p class="text-2xl font-bold text-gray-600 dark:text-gray-400">{{ $stats['production_status_count']['menunggu'] ?? 0 }}</p>
                    <p class="text-xs text-gray-700 dark:text-gray-300 mt-1">Menunggu</p>
                </div>
                <div class="text-center p-3 bg-indigo-50 dark:bg-indigo-900/20 rounded-lg">
                    <p class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">{{ $stats['production_status_count']['dalam_proses'] ?? 0 }}</p>
                    <p class="text-xs text-indigo-700 dark:text-indigo-300 mt-1">Dalam Proses</p>
                </div>
                <div class="text-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg">
                    <p class="text-2xl font-bold text-green-600 dark:text-green-400">{{ $stats['production_status_count']['selesai'] ?? 0 }}</p>
                    <p class="text-xs text-green-700 dark:text-green-300 mt-1">Selesai</p>
                </div>
            </div>
        </div>
    </div>
</div>
