@extends('layouts.teknisi')

@section('title', 'Detail History Produksi - Teknisi')

@section('content')
@php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $materialTotal = $production->total_material_cost ?? 0;
    $sparepartTotal = $production->total_sparepart_cost ?? 0;
    $directTotal = ($production->total_direct_cost ?? ($materialTotal + $sparepartTotal));
    $laborTotal = $production->labor_cost ?? 0;
    $actualTotal = $directTotal + $laborTotal;
@endphp

<div class="space-y-4">
    <!-- Breadcrumb -->
    <nav class="mb-4">
        <ol class="flex items-center space-x-2 text-sm">
            <li>
                <a href="{{ route('teknisi.productions.index') }}" 
                   class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors">
                    <i class="fas fa-industry mr-1"></i>Produksi Aktif
                </a>
            </li>
            <li class="text-gray-500 dark:text-gray-400">
                <i class="fas fa-chevron-right text-xs"></i>
            </li>
            <li>
                <a href="{{ route('teknisi.productions.history') }}" 
                   class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors">
                    History Produksi
                </a>
            </li>
            <li class="text-gray-500 dark:text-gray-400">
                <i class="fas fa-chevron-right text-xs"></i>
            </li>
            <li class="text-gray-900 dark:text-white font-semibold">
                Detail #{{ $production->id }}
            </li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('teknisi.productions.history') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail History Produksi #{{ $production->id }}</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $production->product->product_title ?? 'N/A' }} · Order #{{ $production->order->id ?? 'N/A' }}
                </p>
            </div>
        </div>
        <span class="inline-flex items-center px-3 py-1.5 rounded-md text-sm font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
            <i class="fas fa-check-circle mr-1.5"></i>
            Selesai
        </span>
    </div>

    <!-- Info Cards Row -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <!-- Info Produksi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Produksi</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Qty:</span>
                    <span class="font-semibold text-gray-900 dark:text-white">{{ $orderQty }} unit</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Mulai:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs">
                        {{ $production->start_date ? $production->start_date->format('d/m/Y') : 'N/A' }}
                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Selesai:</span>
                    <span class="font-medium text-emerald-600 dark:text-emerald-400 text-xs">
                        {{ $production->end_date ? $production->end_date->format('d/m/Y') : 'N/A' }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Info Order -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Pesanan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Order ID:</span>
                    <span class="font-medium text-gray-900 dark:text-white">#{{ $production->order->id ?? 'N/A' }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Customer:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs truncate" title="{{ $production->order->customer_name ?? 'N/A' }}">
                        {{ Str::limit($production->order->customer_name ?? 'N/A', 15) }}
                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Harga:</span>
                    <span class="font-semibold text-emerald-600 dark:text-emerald-400">Rp {{ number_format($production->order->total_price ?? 0, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-chart-pie text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Ringkasan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Bahan:</span>
                    <span class="font-medium text-gray-900 dark:text-white">{{ $production->productionMaterials->count() }} item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Sparepart:</span>
                    <span class="font-medium text-gray-900 dark:text-white">{{ $production->productionSpareparts->count() }} item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Total:</span>
                    <span class="font-bold text-indigo-600 dark:text-indigo-400">Rp {{ number_format($actualTotal, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>

        <!-- Payment Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                    <i class="fas fa-credit-card text-orange-600 dark:text-orange-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Pembayaran</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Metode:</span>
                    <span class="font-medium text-gray-900 dark:text-white">{{ strtoupper($production->order->payment_method ?? 'N/A') }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Status:</span>
                    @php
                        $paymentStatus = $production->order->status ?? 'menunggu';
                        $paymentStatusConfig = [
                            'selesai' => ['bg' => 'bg-green-100 dark:bg-green-900/40', 'text' => 'text-green-700 dark:text-green-300', 'label' => 'Lunas'],
                            'diproses' => ['bg' => 'bg-blue-100 dark:bg-blue-900/40', 'text' => 'text-blue-700 dark:text-blue-300', 'label' => 'Diproses'],
                            'menunggu_verifikasi' => ['bg' => 'bg-yellow-100 dark:bg-yellow-900/40', 'text' => 'text-yellow-700 dark:text-yellow-300', 'label' => 'Verifikasi'],
                        ];
                        $paymentStatusStyle = $paymentStatusConfig[$paymentStatus] ?? ['bg' => 'bg-gray-100 dark:bg-gray-700/50', 'text' => 'text-gray-700 dark:text-gray-300', 'label' => ucfirst($paymentStatus)];
                    @endphp
                    <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md {{ $paymentStatusStyle['bg'] }} {{ $paymentStatusStyle['text'] }}">
                        {{ $paymentStatusStyle['label'] }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Catatan Produksi -->
    @if($production->notes)
    <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4 mb-6">
        <h3 class="text-sm font-semibold text-amber-800 dark:text-amber-200 mb-2 flex items-center gap-2">
            <i class="fas fa-sticky-note text-amber-600 dark:text-amber-400"></i> Catatan Produksi
        </h3>
        <p class="text-sm text-amber-700 dark:text-amber-300 whitespace-pre-wrap leading-relaxed">{{ $production->notes }}</p>
    </div>
    @endif

    <!-- Tabel Bahan & Sparepart -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-boxes text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Daftar Bahan & Sparepart</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ $production->productionMaterials->count() + $production->productionSpareparts->count() }} item · {{ $orderQty }} unit produk</p>
                </div>
            </div>
        </div>

        @if($production->productionMaterials->count() > 0 || $production->productionSpareparts->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Nama Item</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Tipe</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Jumlah</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Satuan</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Harga/Unit</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($production->productionMaterials as $pm)
                    <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                        <td class="px-4 py-3.5">
                            <span class="font-medium text-gray-900 dark:text-white text-sm">{{ $pm->material->name ?? 'N/A' }}</span>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-emerald-100 dark:bg-emerald-900/40 text-emerald-700 dark:text-emerald-300">
                                <i class="fas fa-cube text-xs"></i> Bahan
                            </span>
                        </td>
                        <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm">{{ $pm->quantity }}</td>
                        <td class="px-4 py-3.5 text-center text-gray-600 dark:text-gray-400 text-sm">{{ $pm->unit }}</td>
                        <td class="px-4 py-3.5 text-right text-gray-600 dark:text-gray-400 text-sm">Rp {{ number_format($pm->unit_cost, 0, ',', '.') }}</td>
                        <td class="px-4 py-3.5 text-right font-semibold text-gray-900 dark:text-white text-sm">Rp {{ number_format($pm->total_cost, 0, ',', '.') }}</td>
                    </tr>
                    @endforeach
                    @foreach($production->productionSpareparts as $ps)
                    <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                        <td class="px-4 py-3.5">
                            <span class="font-medium text-gray-900 dark:text-white text-sm">{{ $ps->sparepart->name ?? 'N/A' }}</span>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog text-xs"></i> Sparepart
                            </span>
                        </td>
                        <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm">{{ $ps->quantity }}</td>
                        <td class="px-4 py-3.5 text-center text-gray-600 dark:text-gray-400 text-sm">{{ $ps->unit }}</td>
                        <td class="px-4 py-3.5 text-right text-gray-600 dark:text-gray-400 text-sm">Rp {{ number_format($ps->unit_cost, 0, ',', '.') }}</td>
                        <td class="px-4 py-3.5 text-right font-semibold text-gray-900 dark:text-white text-sm">Rp {{ number_format($ps->total_cost, 0, ',', '.') }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700/50 border-t border-gray-200 dark:border-gray-600">
                    <tr>
                        <td colspan="5" class="px-4 py-3.5">
                            <div class="flex flex-wrap items-center gap-3 text-sm">
                                <span class="inline-flex items-center gap-1.5 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-cube text-xs"></i> Bahan: Rp {{ number_format($materialTotal, 0, ',', '.') }}
                                </span>
                                <span class="inline-flex items-center gap-1.5 text-blue-700 dark:text-blue-300">
                                    <i class="fas fa-cog text-xs"></i> Sparepart: Rp {{ number_format($sparepartTotal, 0, ',', '.') }}
                                </span>
                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-right font-bold text-gray-900 dark:text-white">
                            Total: Rp {{ number_format($directTotal, 0, ',', '.') }}
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @else
        <div class="p-12 text-center">
            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
            </div>
            <p class="text-gray-500 dark:text-gray-400 font-medium">Belum ada bahan atau sparepart ditambahkan</p>
        </div>
        @endif
    </div>

    <!-- Cost Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        @if($laborTotal > 0)
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                        <i class="fas fa-users text-orange-600 dark:text-orange-400 text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Biaya Tenaga Kerja</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400">Upah untuk {{ $orderQty }} unit</p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-orange-600 dark:text-orange-400">Rp {{ number_format($laborTotal, 0, ',', '.') }}</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Per unit: Rp {{ number_format($laborTotal / max($orderQty, 1), 0, ',', '.') }}</p>
                </div>
            </div>
        </div>
        @endif

        <!-- Total Cost Summary -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                        <i class="fas fa-calculator text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Total Biaya Produksi</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            Langsung: Rp {{ number_format($directTotal, 0, ',', '.') }}
                            @if($laborTotal > 0)
                                · Labor: Rp {{ number_format($laborTotal, 0, ',', '.') }}
                            @endif
                        </p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-indigo-600 dark:text-indigo-400">Rp {{ number_format($actualTotal, 0, ',', '.') }}</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Per unit: Rp {{ number_format($actualTotal / max($orderQty, 1), 0, ',', '.') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Breakdown Detail -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 mb-6">
        <div class="flex items-center gap-3 mb-4">
            <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                <i class="fas fa-chart-bar text-purple-600 dark:text-purple-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-900 dark:text-white">Breakdown Biaya Detail</h3>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1 uppercase">Bahan</div>
                <div class="text-lg font-bold text-blue-700 dark:text-blue-300">
                    Rp {{ number_format($materialTotal, 0, ',', '.') }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    /unit: Rp {{ number_format($materialTotal / max($orderQty, 1), 0, ',', '.') }}
                </div>
            </div>
            <div class="p-3 bg-emerald-50 dark:bg-emerald-900/20 rounded-lg border border-emerald-200 dark:border-emerald-800">
                <div class="text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1 uppercase">Sparepart</div>
                <div class="text-lg font-bold text-emerald-700 dark:text-emerald-300">
                    Rp {{ number_format($sparepartTotal, 0, ',', '.') }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    /unit: Rp {{ number_format($sparepartTotal / max($orderQty, 1), 0, ',', '.') }}
                </div>
            </div>
            <div class="p-3 bg-indigo-50 dark:bg-indigo-900/20 rounded-lg border border-indigo-200 dark:border-indigo-800">
                <div class="text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1 uppercase">Langsung</div>
                <div class="text-lg font-bold text-indigo-700 dark:text-indigo-300">
                    Rp {{ number_format($directTotal, 0, ',', '.') }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    /unit: Rp {{ number_format($directTotal / max($orderQty, 1), 0, ',', '.') }}
                </div>
            </div>
            @if($laborTotal > 0)
            <div class="p-3 bg-amber-50 dark:bg-amber-900/20 rounded-lg border border-amber-200 dark:border-amber-800">
                <div class="text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1 uppercase">Labor</div>
                <div class="text-lg font-bold text-amber-700 dark:text-amber-300">
                    Rp {{ number_format($laborTotal, 0, ',', '.') }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    /unit: Rp {{ number_format($laborTotal / max($orderQty, 1), 0, ',', '.') }}
                </div>
            </div>
            @endif
        </div>
        <div class="mt-4 pt-4 border-t border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between p-4 bg-indigo-50 dark:bg-indigo-900/20 rounded-lg border-2 border-indigo-300 dark:border-indigo-700">
                <div>
                    <div class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1">Total Aktual (Langsung + Labor)</div>
                    <div class="text-xs text-gray-600 dark:text-gray-400">Per unit: Rp {{ number_format($actualTotal / max($orderQty, 1), 0, ',', '.') }}</div>
                </div>
                <div class="text-2xl font-extrabold text-indigo-700 dark:text-indigo-300">
                    Rp {{ number_format($actualTotal, 0, ',', '.') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <div class="flex justify-end items-center pt-4 border-t border-gray-200 dark:border-gray-700">
        <a href="{{ route('teknisi.productions.history') }}" 
           class="inline-flex items-center gap-2 px-4 py-2 bg-gray-600 hover:bg-gray-700 dark:bg-gray-700 dark:hover:bg-gray-800 text-white rounded-lg text-sm font-medium transition-colors duration-200">
            <i class="fas fa-arrow-left"></i>
            <span>Kembali ke History</span>
        </a>
    </div>
</div>
@endsection
