<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAPORAN PRODUKSI #{{ $production->id }} - {{ date('d M Y') }}</title>
    <style>
        @page {
            margin: 20mm 15mm;
            size: A4;
        }
        
        body {
            font-family: 'Times New Roman', serif;
            margin: 0;
            padding: 0;
            background-color: white;
            color: #000000;
            font-size: 11pt;
            line-height: 1.5;
        }
        
        /* Header dengan Kop Surat */
        .letterhead {
            border-bottom: 3px solid #000000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: bold;
            text-align: center;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 10pt;
            text-align: center;
            margin-bottom: 8px;
            color: #333333;
        }
        
        .company-contact {
            font-size: 9pt;
            text-align: center;
            color: #666666;
            margin-bottom: 10px;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: bold;
            text-align: center;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .report-number {
            font-size: 10pt;
            text-align: center;
            margin-top: 5px;
        }
        
        /* Informasi Dokumen */
        .document-info {
            margin: 20px 0;
            font-size: 10pt;
        }
        
        .document-info table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .document-info td {
            padding: 3px 5px;
            border: none;
            vertical-align: top;
        }
        
        .document-info td.label {
            width: 30%;
            font-weight: bold;
        }
        
        .document-info td.value {
            width: 70%;
        }
        
        /* Section dengan Border */
        .section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .section-title {
            font-size: 11pt;
            font-weight: bold;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 2px solid #000000;
            text-transform: uppercase;
        }
        
        .section-content {
            margin-top: 10px;
        }
        
        /* Tabel Formal */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 10pt;
        }
        
        table thead th {
            background-color: #f0f0f0;
            border: 1px solid #000000;
            padding: 8px 5px;
            text-align: center;
            font-weight: bold;
            font-size: 9pt;
        }
        
        table tbody td {
            border: 1px solid #000000;
            padding: 6px 5px;
            text-align: left;
            font-size: 9pt;
        }
        
        table tbody td.text-center {
            text-align: center;
        }
        
        table tbody td.text-right {
            text-align: right;
        }
        
        table tfoot td {
            border: 1px solid #000000;
            padding: 6px 5px;
            font-weight: bold;
            background-color: #f9f9f9;
        }
        
        table tfoot td.text-right {
            text-align: right;
        }
        
        /* Info Grid Formal */
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        
        .info-table td {
            border: 1px solid #000000;
            padding: 6px 8px;
            font-size: 10pt;
        }
        
        .info-table td.label {
            width: 35%;
            background-color: #f9f9f9;
            font-weight: bold;
        }
        
        .info-table td.value {
            width: 65%;
        }
        
        /* Ringkasan Biaya Formal */
        .cost-summary {
            margin: 20px 0;
            border: 2px solid #000000;
            padding: 15px;
        }
        
        .cost-summary-title {
            font-size: 11pt;
            font-weight: bold;
            text-align: center;
            margin-bottom: 15px;
            text-transform: uppercase;
        }
        
        .cost-item {
            display: table;
            width: 100%;
            margin-bottom: 10px;
        }
        
        .cost-item-label {
            display: table-cell;
            width: 70%;
            padding-right: 10px;
            font-size: 10pt;
        }
        
        .cost-item-value {
            display: table-cell;
            width: 30%;
            text-align: right;
            font-size: 10pt;
            font-weight: bold;
        }
        
        .cost-total {
            border-top: 2px solid #000000;
            margin-top: 10px;
            padding-top: 10px;
            display: table;
            width: 100%;
        }
        
        .cost-total-label {
            display: table-cell;
            width: 70%;
            font-size: 11pt;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .cost-total-value {
            display: table-cell;
            width: 30%;
            text-align: right;
            font-size: 12pt;
            font-weight: bold;
        }
        
        /* Catatan */
        .notes-section {
            margin: 20px 0;
            border: 1px solid #000000;
            padding: 10px;
        }
        
        .notes-title {
            font-size: 10pt;
            font-weight: bold;
            margin-bottom: 8px;
        }
        
        .notes-content {
            font-size: 10pt;
            text-align: justify;
            line-height: 1.6;
        }
        
        /* Footer */
        .footer {
            margin-top: 40px;
            border-top: 1px solid #000000;
            padding-top: 10px;
            font-size: 9pt;
            color: #666666;
        }
        
        .footer table {
            width: 100%;
            border: none;
        }
        
        .footer td {
            border: none;
            padding: 2px 0;
        }
        
        /* Signature Section */
        .signature-section {
            margin-top: 50px;
            display: table;
            width: 100%;
        }
        
        .signature-box {
            display: table-cell;
            width: 50%;
            text-align: center;
            vertical-align: top;
        }
        
        .signature-line {
            border-bottom: 1px solid #000000;
            width: 200px;
            margin: 0 auto 5px auto;
            height: 50px;
        }
        
        .signature-label {
            font-size: 10pt;
            margin-top: 5px;
        }
        
        .signature-name {
            font-size: 10pt;
            font-weight: bold;
            margin-top: 5px;
        }
        
        /* Utility Classes */
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .mb-10 {
            margin-bottom: 10px;
        }
        
        .mt-10 {
            margin-top: 10px;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            font-style: italic;
            color: #666666;
            border: 1px solid #cccccc;
        }
    </style>
</head>
<body>
    <!-- Kop Surat -->
    <div class="letterhead">
        <div class="company-name">{{ $companySettings['company_name'] ?? 'POLJAM TECH' }}</div>
        <div class="company-address">
            {{ $companySettings['company_address'] ?? 'Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi' }}
        </div>
        @if(isset($companySettings['company_phone']) && $companySettings['company_phone'])
        <div class="company-contact">
            Telp: {{ $companySettings['company_phone'] }}
            @if(isset($companySettings['company_email']) && $companySettings['company_email'])
            | Email: {{ $companySettings['company_email'] }}
            @endif
        </div>
        @endif
        <div class="report-title">Laporan Produksi</div>
        <div class="report-number">
            Nomor: PROD-{{ str_pad($production->id, 6, '0', STR_PAD_LEFT) }} | Tanggal: {{ now()->format('d M Y') }}
        </div>
    </div>

    <!-- Informasi Dokumen -->
    <div class="document-info">
        <table>
            <tr>
                <td class="label">Order ID</td>
                <td class="value">: #{{ $production->order->id ?? 'N/A' }}</td>
                <td class="label">Status</td>
                <td class="value">: {{ ucfirst(str_replace('_', ' ', $production->status)) }}</td>
            </tr>
            <tr>
                <td class="label">Customer</td>
                <td class="value">: {{ $production->order->customer_name ?? 'N/A' }}</td>
                <td class="label">Quantity</td>
                <td class="value">: {{ $production->quantity ?? 1 }} unit</td>
            </tr>
            <tr>
                <td class="label">Produk</td>
                <td class="value" colspan="3">: {{ $production->product->product_title ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Teknisi</td>
                <td class="value">: {{ $production->teknisi->name ?? 'N/A' }}</td>
                @if($production->supervisor)
                <td class="label">Supervisor</td>
                <td class="value">: {{ $production->supervisor->name ?? 'N/A' }}</td>
                @else
                <td colspan="2"></td>
                @endif
            </tr>
        </table>
    </div>

    <!-- Timeline Produksi -->
    <div class="section">
        <div class="section-title">Timeline Produksi</div>
        <div class="section-content">
            <table class="info-table">
                <tr>
                    <td class="label">Ditugaskan</td>
                    <td class="value">{{ $production->assigned_at ? $production->assigned_at->format('d M Y, H:i') : 'N/A' }}</td>
                </tr>
                @if($production->actual_start_date)
                <tr>
                    <td class="label">Mulai Produksi</td>
                    <td class="value">{{ $production->actual_start_date->format('d M Y, H:i') }}</td>
                </tr>
                @endif
                @if($production->estimated_completion_date)
                <tr>
                    <td class="label">Estimasi Selesai</td>
                    <td class="value">{{ $production->estimated_completion_date->format('d M Y') }}</td>
                </tr>
                @endif
                @if($production->completed_at)
                <tr>
                    <td class="label">Selesai</td>
                    <td class="value">{{ $production->completed_at->format('d M Y, H:i') }}</td>
                </tr>
                @endif
                @if($actualDurationFormatted)
                <tr>
                    <td class="label">Durasi Aktual</td>
                    <td class="value">{{ $actualDurationFormatted }}</td>
                </tr>
                @endif
                @if($production->estimated_duration_days)
                <tr>
                    <td class="label">Durasi Estimasi</td>
                    <td class="value">{{ $production->estimated_duration_days }} hari</td>
                </tr>
                @endif
            </table>
        </div>
    </div>

    <!-- Status Approval -->
    <div class="section">
        <div class="section-title">Status Approval</div>
        <div class="section-content">
            <table class="info-table">
                <tr>
                    <td class="label">Planning Status</td>
                    <td class="value">{{ ucfirst(str_replace('_', ' ', $production->planning_status ?? 'planning')) }}</td>
                </tr>
                @if($production->approved_at)
                <tr>
                    <td class="label">Tanggal Approval</td>
                    <td class="value">{{ $production->approved_at->format('d M Y, H:i') }}</td>
                </tr>
                @endif
                @if($production->completion_status)
                <tr>
                    <td class="label">Completion Status</td>
                    <td class="value">{{ ucfirst(str_replace('_', ' ', $production->completion_status)) }}</td>
                </tr>
                @endif
                @if($production->completion_approved_at)
                <tr>
                    <td class="label">Tanggal Completion Approval</td>
                    <td class="value">{{ $production->completion_approved_at->format('d M Y, H:i') }}</td>
                </tr>
                @endif
            </table>
        </div>
    </div>

    <!-- Biaya Bahan Baku -->
    <div class="section">
        <div class="section-title">Detail Biaya Bahan Baku</div>
        <div class="section-content">
            @if($production->productionMaterials->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 40%;">Nama Bahan Baku</th>
                        <th style="width: 12%;" class="text-center">Quantity</th>
                        <th style="width: 10%;" class="text-center">Unit</th>
                        <th style="width: 18%;" class="text-right">Harga/Unit</th>
                        <th style="width: 15%;" class="text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($production->productionMaterials as $index => $pm)
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>
                        <td>{{ $pm->material->name ?? 'N/A' }}</td>
                        <td class="text-center">{{ number_format($pm->quantity, 2, ',', '.') }}</td>
                        <td class="text-center">{{ $pm->unit }}</td>
                        <td class="text-right">Rp {{ number_format($pm->unit_cost, 0, ',', '.') }}</td>
                        <td class="text-right">Rp {{ number_format($pm->total_cost, 0, ',', '.') }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="5" class="text-right">Total Biaya Bahan Baku</td>
                        <td class="text-right">Rp {{ number_format($materialTotal, 0, ',', '.') }}</td>
                    </tr>
                </tfoot>
            </table>
            @else
            <div class="no-data">Tidak ada bahan baku</div>
            @endif
        </div>
    </div>

    <!-- Biaya Sparepart -->
    <div class="section">
        <div class="section-title">Detail Biaya Sparepart</div>
        <div class="section-content">
            @if($production->productionSpareparts->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 40%;">Nama Sparepart</th>
                        <th style="width: 12%;" class="text-center">Quantity</th>
                        <th style="width: 10%;" class="text-center">Unit</th>
                        <th style="width: 18%;" class="text-right">Harga/Unit</th>
                        <th style="width: 15%;" class="text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($production->productionSpareparts as $index => $ps)
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>
                        <td>{{ $ps->sparepart->name ?? 'N/A' }}</td>
                        <td class="text-center">{{ number_format($ps->quantity, 2, ',', '.') }}</td>
                        <td class="text-center">{{ $ps->unit }}</td>
                        <td class="text-right">Rp {{ number_format($ps->unit_cost, 0, ',', '.') }}</td>
                        <td class="text-right">Rp {{ number_format($ps->total_cost, 0, ',', '.') }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="5" class="text-right">Total Biaya Sparepart</td>
                        <td class="text-right">Rp {{ number_format($sparepartTotal, 0, ',', '.') }}</td>
                    </tr>
                </tfoot>
            </table>
            @else
            <div class="no-data">Tidak ada sparepart</div>
            @endif
        </div>
    </div>

    <!-- Ringkasan Biaya -->
    <div class="section">
        <div class="section-title">Ringkasan Biaya Produksi</div>
        <div class="cost-summary">
            <div class="cost-item">
                <div class="cost-item-label">Biaya Bahan Baku</div>
                <div class="cost-item-value">Rp {{ number_format($materialTotal, 0, ',', '.') }}</div>
            </div>
            <div class="cost-item">
                <div class="cost-item-label">Biaya Sparepart</div>
                <div class="cost-item-value">Rp {{ number_format($sparepartTotal, 0, ',', '.') }}</div>
            </div>
            <div class="cost-item">
                <div class="cost-item-label">Upah Labor</div>
                <div class="cost-item-value">Rp {{ number_format($laborTotal, 0, ',', '.') }}</div>
            </div>
            <div class="cost-total">
                <div class="cost-total-label">Total Biaya Produksi</div>
                <div class="cost-total-value">Rp {{ number_format($totalCost, 0, ',', '.') }}</div>
            </div>
        </div>
    </div>

    <!-- Catatan -->
    @if($production->notes || $production->completion_notes || $production->supervisor_feedback)
    <div class="section">
        <div class="section-title">Catatan</div>
        <div class="section-content">
            @if($production->notes)
            <div class="notes-section">
                <div class="notes-title">Catatan:</div>
                <div class="notes-content">{{ $production->notes }}</div>
            </div>
            @endif
            @if($production->completion_notes)
            <div class="notes-section">
                <div class="notes-title">Catatan Penyelesaian:</div>
                <div class="notes-content">{{ $production->completion_notes }}</div>
            </div>
            @endif
            @if($production->supervisor_feedback)
            <div class="notes-section">
                <div class="notes-title">Feedback Supervisor:</div>
                <div class="notes-content">{{ $production->supervisor_feedback }}</div>
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Signature Section -->
    <div class="signature-section">
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-label">Teknisi yang Bertanggung Jawab</div>
            <div class="signature-name">{{ $production->teknisi->name ?? 'N/A' }}</div>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-label">Mengetahui, Supervisor</div>
            @if($production->supervisor)
            <div class="signature-name">{{ $production->supervisor->name }}</div>
            @endif
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <table>
            <tr>
                <td class="text-left">
                    <strong>{{ $companySettings['company_name'] ?? 'POLJAM TECH' }}</strong><br>
                    Laporan ini dibuat secara otomatis oleh sistem
                </td>
                <td class="text-right">
                    Halaman 1 dari 1<br>
                    Dicetak pada: {{ now()->format('d M Y H:i') }}
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
