@extends('layouts.main')

@section('title', 'Detail Pesan Kontak')

@section('content')
<div class="min-h-screen py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Detail Pesan Kontak</h1>
                    <p class="mt-2 text-gray-600">ID: #{{ $contact->id }}</p>
                </div>
                <a href="{{ route('user.dashboard') }}" 
                    class="px-4 py-2 bg-gray-200 hover:bg-gray-300 text-gray-800 rounded-lg transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali
                </a>
            </div>
        </div>

        <!-- Contact Details -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <!-- Status Badge -->
            <div class="mb-6">
                @if($contact->is_read)
                    <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-green-100 text-green-800">
                        <i class="fas fa-check-circle mr-2"></i>
                        Pesan Sudah Dibaca oleh Admin
                    </span>
                @else
                    <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-yellow-100 text-yellow-800">
                        <i class="fas fa-clock mr-2"></i>
                        Menunggu Respons Admin
                    </span>
                @endif
            </div>

            <!-- Contact Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Informasi Pengirim</h3>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <i class="fas fa-user text-gray-400 w-5 mr-3"></i>
                            <span class="text-gray-600">Nama:</span>
                            <span class="ml-2 font-medium text-gray-900">{{ $contact->nama }}</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-envelope text-gray-400 w-5 mr-3"></i>
                            <span class="text-gray-600">Email:</span>
                            <span class="ml-2 font-medium text-gray-900">{{ $contact->email }}</span>
                        </div>
                        @if($contact->phone)
                            <div class="flex items-center">
                                <i class="fas fa-phone text-gray-400 w-5 mr-3"></i>
                                <span class="text-gray-600">Telepon:</span>
                                <span class="ml-2 font-medium text-gray-900">{{ $contact->phone }}</span>
                            </div>
                        @endif
                        @if($contact->company)
                            <div class="flex items-center">
                                <i class="fas fa-building text-gray-400 w-5 mr-3"></i>
                                <span class="text-gray-600">Perusahaan:</span>
                                <span class="ml-2 font-medium text-gray-900">{{ $contact->company }}</span>
                            </div>
                        @endif
                    </div>
                </div>
                
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Informasi Pesan</h3>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <i class="fas fa-calendar text-gray-400 w-5 mr-3"></i>
                            <span class="text-gray-600">Tanggal:</span>
                            <span class="ml-2 font-medium text-gray-900">{{ $contact->created_at->format('d M Y H:i') }}</span>
                        </div>
                        @if($contact->subject)
                            <div class="flex items-center">
                                <i class="fas fa-tag text-gray-400 w-5 mr-3"></i>
                                <span class="text-gray-600">Subjek:</span>
                                <span class="ml-2 font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $contact->subject)) }}</span>
                            </div>
                        @endif
                        <div class="flex items-center">
                            <i class="fas fa-clock text-gray-400 w-5 mr-3"></i>
                            <span class="text-gray-600">Status:</span>
                            <span class="ml-2 font-medium text-gray-900">
                                @if($contact->is_read)
                                    Dibaca {{ $contact->updated_at->format('d M Y H:i') }}
                                @else
                                    Belum Dibaca
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Message Content -->
            <div class="border-t border-gray-200 pt-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Isi Pesan</h3>
                <div class="bg-gray-50 rounded-lg p-6">
                    <div class="prose max-w-none">
                        <p class="text-gray-800 whitespace-pre-wrap">{{ $contact->pesan }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="mt-8 flex justify-between items-center">
                <div class="text-sm text-gray-500">
                    <i class="fas fa-info-circle mr-1"></i>
                    Admin akan merespons melalui email yang Anda berikan
                </div>
                <div class="flex gap-3">
                    <a href="{{ route('guest.contact') }}" 
                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Kirim Pesan Baru
                    </a>
                </div>
            </div>
        </div>

        <!-- Related Information -->
        <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Aksi Cepat</h3>
                <div class="space-y-3">
                    <a href="{{ route('guest.contact') }}" 
                        class="flex items-center p-3 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
                        <i class="fas fa-envelope text-blue-600 mr-3"></i>
                        <span class="text-blue-800 font-medium">Kirim Pesan Baru</span>
                    </a>
                    <a href="{{ route('all') }}" 
                        class="flex items-center p-3 bg-green-50 hover:bg-green-100 rounded-lg transition-colors">
                        <i class="fas fa-search text-green-600 mr-3"></i>
                        <span class="text-green-800 font-medium">Lihat Produk</span>
                    </a>
                    <a href="{{ route('user.dashboard') }}" 
                        class="flex items-center p-3 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors">
                        <i class="fas fa-tachometer-alt text-purple-600 mr-3"></i>
                        <span class="text-purple-800 font-medium">Dashboard</span>
                    </a>
                </div>
            </div>

            <!-- Contact Tips -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Tips Komunikasi</h3>
                <div class="space-y-3 text-sm text-gray-600">
                    <div class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
                        <span>Admin biasanya merespons dalam 1-2 hari kerja</span>
                    </div>
                    <div class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
                        <span>Gunakan subjek yang jelas untuk respons lebih cepat</span>
                    </div>
                    <div class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
                        <span>Sertakan detail kebutuhan untuk penawaran yang tepat</span>
                    </div>
                    <div class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
                        <span>Periksa email secara berkala untuk respons admin</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Mark contact notification as viewed when page loads (only if admin has replied)
    document.addEventListener('DOMContentLoaded', function() {
        const contactId = {{ $contact->id }};
        const hasAdminReply = {{ $contact->admin_reply ? 'true' : 'false' }};
        
        if (window.userNotificationSystem && hasAdminReply) {
            // Mark as viewed immediately
            window.userNotificationSystem.markNotificationAsViewed('contact', contactId);
            
            // Force badge update after a short delay to ensure it's updated
            setTimeout(function() {
                if (window.userNotificationSystem) {
                    window.userNotificationSystem.fetchNotifications();
                }
            }, 300);
        }
    });
</script>
@endpush
@endsection

