@extends('layouts.main')

@section('title', 'Dashboard User')

@section('content')
<div class="min-h-screen py-6 sm:py-8">
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
        <!-- Header -->
        <div class="mb-6 sm:mb-8">
            <div>
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Dashboard</h1>
                <p class="text-sm sm:text-base text-gray-600 leading-relaxed">Selamat datang, <span class="font-semibold text-blue-600">{{ Auth::user()->name ?? Auth::user()->email }}</span>!</p>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6 sm:mb-8">
            <!-- Total Orders -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 sm:p-5 hover:shadow-md transition-shadow duration-200">
                <div class="flex items-center mb-3">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-blue-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 sm:w-7 sm:h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-xs sm:text-sm text-gray-600 mb-1">Total Pesanan</p>
                <h3 class="text-2xl sm:text-3xl font-bold text-gray-900">{{ $stats['total_orders'] }}</h3>
            </div>

            <!-- Pending Orders -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 sm:p-5 hover:shadow-md transition-shadow duration-200">
                <div class="flex items-center mb-3">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 sm:w-7 sm:h-7 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-xs sm:text-sm text-gray-600 mb-1">Pesanan Pending</p>
                <h3 class="text-2xl sm:text-3xl font-bold text-gray-900">{{ $stats['pending_orders'] }}</h3>
            </div>

            <!-- Completed Orders -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 sm:p-5 hover:shadow-md transition-shadow duration-200">
                <div class="flex items-center mb-3">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-green-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 sm:w-7 sm:h-7 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-xs sm:text-sm text-gray-600 mb-1">Pesanan Selesai</p>
                <h3 class="text-2xl sm:text-3xl font-bold text-gray-900">{{ $stats['completed_orders'] ?? 0 }}</h3>
            </div>

            <!-- Total Spent -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 sm:p-5 hover:shadow-md transition-shadow duration-200">
                <div class="flex items-center mb-3">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-purple-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 sm:w-7 sm:h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-xs sm:text-sm text-gray-600 mb-1">Total Pengeluaran</p>
                <h3 class="text-lg sm:text-xl font-bold text-gray-900 truncate">{{ $stats['total_spent'] ?? 'Rp 0' }}</h3>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6 sm:mb-8">
            <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-blue-50">
                <h2 class="text-lg sm:text-xl font-bold text-gray-900">Aksi Cepat</h2>
            </div>
            <div class="p-4 sm:p-6">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                    <a href="{{ route('guest.contact') }}" 
                        class="flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-all duration-200">
                        <div class="w-11 h-11 bg-blue-600 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Kirim Pesan</h3>
                            <p class="text-xs text-gray-600">Hubungi admin untuk pertanyaan umum</p>
                        </div>
                    </a>
                    
                    <a href="{{ route('all') }}" 
                        class="flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-all duration-200">
                        <div class="w-11 h-11 bg-blue-600 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Lihat Produk</h3>
                            <p class="text-xs text-gray-600">Jelajahi katalog produk kami</p>
                        </div>
                    </a>
                    
                    <a href="{{ route('user.inquiries.index') }}" 
                        class="flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-all duration-200">
                        <div class="w-11 h-11 bg-blue-600 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Penawaran Produk Saya</h3>
                            <p class="text-xs text-gray-600">Lihat semua penawaran & balasan admin</p>
                        </div>
                    </a>

                    <a href="{{ route('my.orders.index') }}" 
                        class="flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-all duration-200">
                        <div class="w-11 h-11 bg-blue-600 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Pesanan Saya</h3>
                            <p class="text-xs text-gray-600">Lihat status pesanan Anda</p>
                        </div>
                    </a>

                    <a href="{{ route('profile.edit') }}" 
                        class="flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-all duration-200">
                        <div class="w-11 h-11 bg-blue-600 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Edit Profil</h3>
                            <p class="text-xs text-gray-600">Kelola informasi & foto profil</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
            <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-blue-50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900">Pesanan Terbaru</h2>
                    <a href="{{ route('my.orders.index') }}" class="text-sm text-blue-600 hover:text-blue-800 font-medium transition-colors">
                        Lihat Semua
                        <svg class="w-4 h-4 inline ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="p-4 sm:p-6">
                <div class="space-y-3">
                    @forelse($orders as $order)
                        <a href="{{ route('my.orders.show', $order) }}" 
                           class="block flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:border-blue-300 hover:bg-blue-50 transition-all duration-200 group">
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center gap-2 mb-1">
                                    <p class="text-sm font-semibold text-gray-900">#{{ $order->id }}</p>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        {{ $order->order_status === 'diterima' ? 'bg-green-100 text-green-800' : 
                                           ($order->order_status === 'ditolak' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">
                                        {{ $order->order_status_label }}
                                    </span>
                                </div>
                                <p class="text-sm text-gray-700 font-medium truncate leading-tight">{{ $order->product->product_title ?? 'N/A' }}</p>
                                <p class="text-xs text-gray-500 mt-1">{{ $order->created_at->format('d M Y') }}</p>
                            </div>
                            <div class="ml-4 flex-shrink-0">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-blue-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </div>
                        </a>
                    @empty
                        <div class="text-center py-12">
                            <div class="w-16 h-16 mx-auto mb-4 bg-gray-100 rounded-full flex items-center justify-center">
                                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                </svg>
                            </div>
                            <p class="text-sm font-medium text-gray-900 mb-1">Belum ada pesanan</p>
                            <p class="text-xs text-gray-500 mb-4">Mulai berbelanja untuk melihat pesanan Anda di sini</p>
                            <a href="{{ route('all') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                </svg>
                                Lihat Produk
                            </a>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert2 CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@if (session('success'))
    <script>
        Swal.fire({
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            icon: 'success',
            timer: 3000,
            timerProgressBar: true,
            showConfirmButton: false,
            position: 'top-end'
        });
    </script>
@endif

@if (session('error'))
    <script>
        Swal.fire({
            title: 'Error!',
            text: '{{ session('error') }}',
            icon: 'error',
            timer: 3000,
            timerProgressBar: true,
            showConfirmButton: false,
            position: 'top-end'
        });
    </script>
@endif
@endsection
