<!-- Material Purchase Form Card -->
<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 relative mb-5">
    <button type="button"
        class="absolute top-4 right-4 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200"
        onclick="removeItem(this)">
        <i class="fas fa-times text-sm"></i>
    </button>

    <!-- Header Card -->
    <div class="flex items-center mb-5">
        <div class="w-10 h-10 bg-green-100 dark:bg-green-900/40 rounded-lg flex items-center justify-center mr-3">
            <i class="fas fa-cube text-green-600 dark:text-green-400"></i>
        </div>
        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Item Material</h3>
    </div>

    <!-- Item Selection -->
    <div class="mb-5">
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
            Pilih Material atau Buat Baru <span class="text-red-500">*</span>
        </label>
        <select name="items[<?php echo e($index); ?>][item_id]" class="item-select w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
            <option value="">-- Pilih Material atau Buat Baru --</option>
            <?php $__currentLoopData = $materialsForJs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($material['id']); ?>"
                    <?php echo e(old("items.{$index}.item_id") == $material['id'] ? 'selected' : ''); ?>

                    data-name="<?php echo e($material['name']); ?>"
                    data-unit="<?php echo e($material['unit'] ?? 'pcs'); ?>"
                    data-code="<?php echo e($material['material_code'] ?? ''); ?>"
                    data-category="<?php echo e($material['category'] ?? ''); ?>"
                    data-price="<?php echo e($material['price'] ?? 0); ?>"
                    data-description="<?php echo e($material['description'] ?? ''); ?>"
                    data-image="<?php echo e($material['image'] ?? ''); ?>">
                    <?php echo e($material['name']); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- Basic Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Material Code -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Material</label>
            <input type="text" name="items[<?php echo e($index); ?>][material_code]" value="<?php echo e(old("items.{$index}.material_code")); ?>"
                class="code-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Jika kosong, otomatis dibuat unik">
        </div>

        <!-- Nama Material -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Nama Material <span class="text-red-500">*</span>
            </label>
            <input type="text" name="items[<?php echo e($index); ?>][item_name]" value="<?php echo e(old("items.{$index}.item_name")); ?>" required
                class="item-name w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm <?php $__errorArgs = ["items.{$index}.item_name"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                placeholder="Masukkan nama material">
            <?php $__errorArgs = ["items.{$index}.item_name"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Kategori -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kategori</label>
            <input type="text" name="items[<?php echo e($index); ?>][category]" value="<?php echo e(old("items.{$index}.category")); ?>"
                class="category-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Masukkan kategori material">
        </div>
    </div>

    <!-- Purchase Details -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
        <!-- Quantity -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Quantity <span class="text-red-500">*</span>
            </label>
            <input type="number" name="items[<?php echo e($index); ?>][quantity]" min="1" step="1" value="<?php echo e(old("items.{$index}.quantity", 1)); ?>" required
                class="quantity w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm <?php $__errorArgs = ["items.{$index}.quantity"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                placeholder="1">
            <?php $__errorArgs = ["items.{$index}.quantity"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Unit -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
            <input type="text" name="items[<?php echo e($index); ?>][unit]" value="<?php echo e(old("items.{$index}.unit", 'pcs')); ?>"
                class="unit w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="pcs">
        </div>

        <!-- Unit Price -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Harga Satuan (Rp) <span class="text-red-500">*</span>
            </label>
            <input type="number" name="items[<?php echo e($index); ?>][unit_price]" min="0" step="0.01" value="<?php echo e(old("items.{$index}.unit_price")); ?>" required
                class="unit-price w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm <?php $__errorArgs = ["items.{$index}.unit_price"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                placeholder="0">
            <?php $__errorArgs = ["items.{$index}.unit_price"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Total Price (Read-only) -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Total Harga</label>
            <input type="text" readonly
                class="total-price w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white text-sm font-semibold"
                value="Rp 0">
        </div>
    </div>

    <!-- Description & Image -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
        <!-- Deskripsi -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
            <textarea name="items[<?php echo e($index); ?>][description]" rows="3"
                class="description-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm"
                placeholder="Tuliskan deskripsi material jika perlu..."><?php echo e(old("items.{$index}.description")); ?></textarea>
        </div>

        <!-- Gambar -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
            <div class="space-y-3">
                <input type="file" name="items[<?php echo e($index); ?>][image]" accept="image/*" onchange="previewImage(this, 'preview-<?php echo e($index); ?>')"
                    class="image-field w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                
                <!-- Image Preview -->
                <div class="relative w-full max-w-xs">
                    <div id="preview-container-<?php echo e($index); ?>" class="hidden">
                        <div class="relative border border-gray-200 dark:border-gray-600 rounded-lg p-2 bg-gray-50 dark:bg-gray-700/50">
                            <img id="preview-<?php echo e($index); ?>" src="" alt="Preview" 
                                class="w-full h-48 object-contain rounded"
                                style="background: transparent;">
                            
                            <!-- Remove Button -->
                            <button type="button" onclick="removeImage(this, 'preview-<?php echo e($index); ?>')"
                                class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 shadow-lg">
                                <i class="fas fa-times text-sm"></i>
                            </button>
                        </div>
                    </div>
                    <div id="no-image-<?php echo e($index); ?>" class="text-xs text-gray-500 dark:text-gray-400 italic">
                        Belum ada gambar yang dipilih
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Status -->
    <div class="flex items-center">
        <input type="checkbox" name="items[<?php echo e($index); ?>][is_active]" value="1" <?php echo e(old("items.{$index}.is_active", true) ? 'checked' : ''); ?>

            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
        <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
    </div>
</div>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/transaksi/purchases/partials/material-form.blade.php ENDPATH**/ ?>