<!-- Top Products -->
<?php if(isset($recentData['top_products']) && $recentData['top_products']->count() > 0): ?>
<div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700 mb-6">
    <div class="flex items-center justify-between mb-5">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
            <i class="fas fa-star text-yellow-500 mr-2"></i>
            Produk Terlaris
        </h3>
    </div>
    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4">
        <?php $__currentLoopData = $recentData['top_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-700/30 rounded-xl border border-gray-200 dark:border-gray-600 transition-all text-center group">
                <div class="flex items-center justify-center mb-2">
                    <?php if($index < 3): ?>
                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-gradient-to-br <?php echo e($index === 0 ? 'from-yellow-400 to-yellow-600' : ($index === 1 ? 'from-gray-300 to-gray-500' : 'from-orange-400 to-orange-600')); ?> text-white text-sm font-bold mr-2">
                            <?php echo e($index + 1); ?>

                        </span>
                    <?php else: ?>
                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300 text-sm font-bold mr-2">
                            <?php echo e($index + 1); ?>

                        </span>
                    <?php endif; ?>
                </div>
                <p class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($item->order_count); ?></p>
                <p class="text-xs font-medium text-gray-600 dark:text-gray-400 truncate" title="<?php echo e($item->product->product_title ?? 'N/A'); ?>">
                    <?php echo e($item->product->product_title ?? 'N/A'); ?>

                </p>
                <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">order</p>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/partials/dashboard-top-products.blade.php ENDPATH**/ ?>